/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal.external;

import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.api.remote.Command;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.jboss.jca.deployers.fungal.RAActivator;

public class RemoteDeploy
implements Command {
    private MainDeployer mainDeployer;
    private RAActivator activator;
    private File directory;

    public RemoteDeploy(MainDeployer mainDeployer, RAActivator activator, File directory) {
        this.mainDeployer = mainDeployer;
        this.activator = activator;
        this.directory = directory;
    }

    public String getName() {
        return "remote-deploy";
    }

    public Class[] getParameterTypes() {
        return new Class[]{String.class, byte[].class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable invoke(Serializable[] args) {
        boolean activatorEnabled = this.activator.isEnabled();
        try {
            if (args == null || args.length != 2) {
                throw new IllegalArgumentException("Invalid number of arguments");
            }
            if (!(args[0] instanceof String)) {
                throw new IllegalArgumentException("First parameter isn't a String");
            }
            if (!(args[1] instanceof byte[])) {
                throw new IllegalArgumentException("Second parameter isn't a byte[]");
            }
            String name = (String)((Object)args[0]);
            byte[] bytes = (byte[])args[1];
            File deployment = new File(this.directory, name);
            this.activator.setEnabled(false);
            if (deployment.exists()) {
                this.mainDeployer.undeploy(deployment.toURI().toURL());
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(deployment);
                fos.write(bytes);
                fos.flush();
            }
            catch (Throwable ft) {
                throw ft;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            this.mainDeployer.deploy(deployment.toURI().toURL());
        }
        catch (Throwable t) {
            Throwable throwable = t;
            return throwable;
        }
        finally {
            this.activator.setEnabled(activatorEnabled);
        }
        return Boolean.TRUE;
    }

    public boolean isPublic() {
        return true;
    }
}

