/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.util.Injection;
import com.github.fungal.api.util.JMX;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.naming.ExplicitJndiStrategy;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.AbstractDsDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.DriverRegistry;
import org.jboss.jca.deployers.fungal.DsXmlDeployment;
import org.jboss.jca.deployers.fungal.DsXmlDeployments;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public class DsXmlDeployer
extends AbstractDsDeployer
implements Deployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)DsXmlDeployer.class.getName());
    private String jdbcLocal = null;
    private String jdbcXA = null;
    private Kernel kernel = null;
    private MetadataRepository mdr = null;
    private ResourceAdapterRepository resourceAdapterRepository = null;
    private DriverRegistry driverRegistry = null;

    public void setJDBCLocal(String value) {
        this.jdbcLocal = value;
    }

    public String getJDBCLocal() {
        return this.jdbcLocal;
    }

    public void setJDBCXA(String value) {
        this.jdbcXA = value;
    }

    public String getJDBCXA() {
        return this.jdbcXA;
    }

    protected DeployersLogger getLogger() {
        return log;
    }

    public void setDriverRegistry(DriverRegistry value) {
        this.driverRegistry = value;
    }

    public boolean accepts(URL url) {
        return url != null && !url.toExternalForm().startsWith("jar") && url.toExternalForm().endsWith("-ds.xml");
    }

    public int getOrder() {
        return 0;
    }

    public synchronized Deployment deploy(URL url, Context context, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying: " + url.toExternalForm()));
        }
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        InputStream is = null;
        try {
            List<ObjectName> onames;
            CommonDeployment c;
            DatasourcesImpl dsD;
            Object urlJdbcXA;
            File f = this.getFileFromUrl(url);
            if (!f.exists()) {
                throw new IOException("Deployment " + url.toExternalForm() + " doesnt exists");
            }
            is = new FileInputStream(f);
            DsParser dsParser = new DsParser();
            DataSources dataSources = dsParser.parse(is);
            String deploymentName = f.getName();
            Set raDeployments = this.mdr.getResourceAdapters();
            String uniqueJdbcLocalId = null;
            String uniqueJdbcXAId = null;
            for (String s : raDeployments) {
                if (s.endsWith(this.jdbcLocal)) {
                    URL urlJdbcLocal = new URL(s);
                    uniqueJdbcLocalId = urlJdbcLocal.toExternalForm();
                    continue;
                }
                if (!s.endsWith(this.jdbcXA)) continue;
                urlJdbcXA = new URL(s);
                uniqueJdbcXAId = ((URL)urlJdbcXA).toExternalForm();
            }
            this.kernel = context.getKernel();
            if (this.numberOfDataSources(dataSources) == 1 || this.verifyTypes(dataSources)) {
                CommonDeployment c2 = this.createObjectsAndInjectValue(url, deploymentName, uniqueJdbcLocalId, uniqueJdbcXAId, dataSources, parent);
                List<ObjectName> onames2 = this.registerManagementView(c2.getDataSources(), this.kernel.getMBeanServer(), this.kernel.getName());
                urlJdbcXA = new DsXmlDeployment(c2.getURL(), c2.getDeploymentName(), c2.getResourceAdapter(), c2.getResourceAdapterKey(), c2.getBootstrapContextIdentifier(), this.resourceAdapterRepository, c2.getCfs(), c2.getCfJndiNames(), c2.getConnectionManagers(), c2.getRecovery(), this.getXAResourceRecoveryRegistry(), c2.getDataSources(), this.getManagementRepository(), onames2, this.kernel.getMBeanServer(), c2.getCl());
                return urlJdbcXA;
            }
            ArrayList<DsXmlDeployment> deployments = new ArrayList<DsXmlDeployment>();
            HashMap<String, Driver> driversMap = new HashMap<String, Driver>();
            for (Driver driver : dataSources.getDrivers()) {
                driversMap.put(driver.getName(), driver);
            }
            for (DataSource ds : dataSources.getDataSource()) {
                dsD = new DatasourcesImpl(Arrays.asList(ds), null, driversMap);
                c = this.createObjectsAndInjectValue(url, deploymentName, uniqueJdbcLocalId, null, (DataSources)dsD, parent);
                onames = this.registerManagementView(c.getDataSources(), this.kernel.getMBeanServer(), this.kernel.getName());
                deployments.add(new DsXmlDeployment(c.getURL(), c.getDeploymentName(), c.getResourceAdapter(), c.getResourceAdapterKey(), c.getBootstrapContextIdentifier(), this.resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getConnectionManagers(), c.getRecovery(), this.getXAResourceRecoveryRegistry(), c.getDataSources(), this.getManagementRepository(), onames, this.kernel.getMBeanServer(), c.getCl()));
            }
            for (XaDataSource xads : dataSources.getXaDataSource()) {
                dsD = new DatasourcesImpl(null, Arrays.asList(xads), driversMap);
                c = this.createObjectsAndInjectValue(url, deploymentName, null, uniqueJdbcXAId, (DataSources)dsD, parent);
                onames = this.registerManagementView(c.getDataSources(), this.kernel.getMBeanServer(), this.kernel.getName());
                deployments.add(new DsXmlDeployment(c.getURL(), c.getDeploymentName(), c.getResourceAdapter(), c.getResourceAdapterKey(), c.getBootstrapContextIdentifier(), this.resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getConnectionManagers(), c.getRecovery(), this.getXAResourceRecoveryRegistry(), c.getDataSources(), this.getManagementRepository(), onames, this.kernel.getMBeanServer(), c.getCl()));
            }
            DsXmlDeployments dsXmlDeployments = new DsXmlDeployments(url, deployments, ((DsXmlDeployment)deployments.get(0)).getClassLoader());
            return dsXmlDeployments;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            this.cleanTemporaryFiles(url);
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    protected File getFileFromUrl(URL url) throws URISyntaxException, IOException {
        return new File(url.toURI());
    }

    protected String getIronJacamarHome() {
        return SecurityActions.getSystemProperty("iron.jacamar.home");
    }

    protected void cleanTemporaryFiles(URL url) throws com.github.fungal.spi.deployers.DeployException {
    }

    public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
        try {
            Class<?> clz = Class.forName(className, true, cl);
            Object o = clz.newInstance();
            if (configs != null) {
                Injection injector = new Injection();
                for (ConfigProperty configProperty : configs) {
                    if (!configProperty.isValueSet()) continue;
                    injector.inject(o, configProperty.getConfigPropertyName().getValue(), (Object)configProperty.getConfigPropertyValue().getValue(), configProperty.getConfigPropertyType().getValue());
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + className + " failed", t);
        }
    }

    protected String[] bindConnectionFactory(String deployment, String jndi, Object cf) throws Throwable {
        ExplicitJndiStrategy js = new ExplicitJndiStrategy();
        String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
        log.infof("Bound data source at: %s", (Object)jndi);
        return result;
    }

    protected String getDriver(String driverName, String moduleId) {
        String driver = this.driverRegistry.getDriver(driverName);
        if (driver == null) {
            driver = this.driverRegistry.getDriver(moduleId);
        }
        return driver;
    }

    public void start() {
        if (this.transactionIntegration == null) {
            throw new IllegalStateException("TransactionIntegration not defined");
        }
        if (this.mdr == null) {
            throw new IllegalStateException("MetadataRepository not defined");
        }
        if (this.resourceAdapterRepository == null) {
            throw new IllegalStateException("ResourceAdapterRepository not defined");
        }
        if (this.jdbcLocal == null) {
            throw new IllegalStateException("JDBCLocal not defined");
        }
        if (this.jdbcXA == null) {
            throw new IllegalStateException("JDBCXA not defined");
        }
        if (this.getCachedConnectionManager() == null) {
            throw new IllegalStateException("CachedConnectionManager not defined");
        }
    }

    protected ClassLoader getDeploymentClassLoader(String uniqueId) {
        try {
            URL urlJdbc = new URL(uniqueId);
            List deployments = this.kernel.getDeployments(urlJdbc);
            Deployment deployment = null;
            if (deployments != null && deployments.size() > 0) {
                for (int i = 0; deployment == null && i < deployments.size(); ++i) {
                    deployment = (Deployment)deployments.get(i);
                }
                return deployment.getClassLoader();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
        throw new RuntimeException("No classloader was found for: " + uniqueId);
    }

    protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
        log.tracef("getSubjectFactory(%s)", (Object)securityDomain);
        if (securityDomain == null || securityDomain.trim().equals("")) {
            return null;
        }
        try {
            return (SubjectFactory)this.kernel.getBean(securityDomain, SubjectFactory.class);
        }
        catch (Throwable t) {
            throw new DeployException("Error during loookup of security domain: " + securityDomain, t);
        }
    }

    private List<ObjectName> registerManagementView(org.jboss.jca.core.api.management.DataSource[] mgtDses, MBeanServer server, String domain) throws JMException {
        ArrayList<ObjectName> ons = null;
        if (mgtDses != null && server != null) {
            ons = new ArrayList<ObjectName>();
            for (org.jboss.jca.core.api.management.DataSource mgtDs : mgtDses) {
                String jndiName = mgtDs.getJndiName();
                if (jndiName.indexOf("/") != -1) {
                    jndiName = jndiName.substring(jndiName.lastIndexOf("/") + 1);
                }
                String baseName = domain + ":deployment=" + jndiName;
                if (mgtDs.getPoolConfiguration() != null) {
                    String dsPCName = baseName + ",type=PoolConfigutation";
                    DynamicMBean dsPCDMB = JMX.createMBean((Object)mgtDs.getPoolConfiguration(), (String)"Pool configuration");
                    ObjectName dsPCON = new ObjectName(dsPCName);
                    server.registerMBean(dsPCDMB, dsPCON);
                    ons.add(dsPCON);
                }
                if (mgtDs.getPool() != null) {
                    String dsPName = baseName + ",type=Pool";
                    DynamicMBean dsPDMB = JMX.createMBean((Object)mgtDs.getPool(), (String)"Pool");
                    ObjectName dsPON = new ObjectName(dsPName);
                    server.registerMBean(dsPDMB, dsPON);
                    ons.add(dsPON);
                    if (mgtDs.getPool().getStatistics() != null) {
                        String dsPSName = baseName + ",type=PoolStatistics";
                        HashSet<String> writeAttributes = new HashSet<String>();
                        writeAttributes.add("Enabled");
                        HashSet excludeAttributes = new HashSet();
                        HashSet<String> excludeOperations = new HashSet<String>();
                        excludeOperations.add("delta(.)*");
                        DynamicMBean dsPSDMB = JMX.createMBean((Object)mgtDs.getPool().getStatistics(), (String)"PoolStatistics", writeAttributes, null, excludeAttributes, excludeOperations);
                        ObjectName dsPSON = new ObjectName(dsPSName);
                        server.registerMBean(dsPSDMB, dsPSON);
                        ons.add(dsPSON);
                    }
                }
                if (mgtDs.getStatistics() == null) continue;
                String dsSName = baseName + ",type=Statistics";
                HashSet<String> writeAttributes = new HashSet<String>();
                writeAttributes.add("Enabled");
                HashSet excludeAttributes = new HashSet();
                HashSet<String> excludeOperations = new HashSet<String>();
                excludeOperations.add("delta(.)*");
                DynamicMBean dsSDMB = JMX.createMBean((Object)mgtDs.getStatistics(), (String)"Statistics", writeAttributes, null, excludeAttributes, excludeOperations);
                ObjectName dsSON = new ObjectName(dsSName);
                server.registerMBean(dsSDMB, dsSON);
                ons.add(dsSON);
            }
        }
        return ons;
    }

    protected ResourceAdapter createRa(String uniqueId, ClassLoader cl) throws NotFoundException, Exception, com.github.fungal.spi.deployers.DeployException {
        Connector md = this.mdr.getResourceAdapter(uniqueId);
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter ra = md.getResourceadapter();
        ArrayList l = new ArrayList();
        ResourceAdapter rar = (ResourceAdapter)this.initAndInject(ra.getResourceadapterClass(), l, cl);
        return rar;
    }

    protected String registerResourceAdapterToResourceAdapterRepository(ResourceAdapter instance) {
        return this.getResourceAdapterRepository().registerResourceAdapter(instance);
    }

    protected ManagedConnectionFactory createMcf(XaDataSource ds, String uniqueId, ClassLoader cl) throws NotFoundException, Exception, com.github.fungal.spi.deployers.DeployException {
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(uniqueId);
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter ra = md.getResourceadapter();
        List cds = ra.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        this.initAndInjectClassLoaderPlugin(mcf, (CommonDataSource)ds);
        return mcf;
    }

    protected ManagedConnectionFactory createMcf(DataSource ds, String uniqueId, ClassLoader cl) throws NotFoundException, Exception, com.github.fungal.spi.deployers.DeployException {
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(uniqueId);
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter ra = md.getResourceadapter();
        List cds = ra.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        this.initAndInjectClassLoaderPlugin(mcf, (CommonDataSource)ds);
        return mcf;
    }

    public void setMetadataRepository(MetadataRepository value) {
        this.mdr = value;
    }

    public MetadataRepository getMetadataRepository() {
        return this.mdr;
    }

    public void setResourceAdapterRepository(ResourceAdapterRepository value) {
        this.resourceAdapterRepository = value;
    }

    public ResourceAdapterRepository getResourceAdapterRepository() {
        return this.resourceAdapterRepository;
    }
}

