/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal.external;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.api.remote.Command;
import com.github.fungal.api.remote.Communicator;
import java.io.File;
import java.io.IOException;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.fungal.RAActivator;
import org.jboss.jca.deployers.fungal.external.RemoteDeploy;
import org.jboss.jca.deployers.fungal.external.RemoteList;
import org.jboss.jca.deployers.fungal.external.RemoteUndeploy;
import org.jboss.logging.Logger;

public class RemoteDeployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RemoteDeployer.class.getName());
    private Kernel kernel = null;
    private Communicator communicator = null;
    private String directory = null;
    private RemoteDeploy remoteDeploy = null;
    private RemoteUndeploy remoteUndeploy = null;
    private RemoteList remoteList = null;

    public void setKernel(Kernel v) {
        this.kernel = v;
    }

    public void setDirectory(String v) {
        this.directory = v;
    }

    public void start() throws Throwable {
        this.communicator = (Communicator)this.kernel.getBean("Communicator", Communicator.class);
        if (this.directory == null || this.directory.trim().equals("")) {
            throw new IllegalStateException("Directory must be defined");
        }
        File rd = new File(this.directory);
        if (!rd.exists() && !rd.mkdirs()) {
            throw new IOException("Directory couldn't be created");
        }
        MainDeployer mainDeployer = this.kernel.getMainDeployer();
        RAActivator activator = (RAActivator)((Object)this.kernel.getBean("RAActivator", RAActivator.class));
        this.remoteDeploy = new RemoteDeploy(mainDeployer, activator, rd);
        this.remoteUndeploy = new RemoteUndeploy(mainDeployer, activator, rd);
        this.remoteList = new RemoteList(rd);
        this.communicator.registerCommand((Command)this.remoteDeploy);
        this.communicator.registerCommand((Command)this.remoteUndeploy);
        this.communicator.registerCommand((Command)this.remoteList);
    }

    public void stop() throws Throwable {
        File[] files;
        File rd;
        if (this.communicator != null) {
            if (this.remoteList != null) {
                this.communicator.unregisterCommand((Command)this.remoteList);
            }
            if (this.remoteUndeploy != null) {
                this.communicator.unregisterCommand((Command)this.remoteUndeploy);
            }
            if (this.remoteDeploy != null) {
                this.communicator.unregisterCommand((Command)this.remoteDeploy);
            }
        }
        if ((rd = new File(this.directory)).exists() && (files = rd.listFiles()) != null) {
            MainDeployer mainDeployer = this.kernel.getMainDeployer();
            for (File deployment : files) {
                try {
                    mainDeployer.undeploy(deployment.toURI().toURL());
                }
                catch (Throwable t) {
                    log.warn((Object)("Exception during undeploy: " + t.getMessage()), t);
                }
            }
        }
    }
}

