/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.embedded.arquillian;

import org.jboss.arquillian.protocol.local.LocalMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.jca.embedded.EmbeddedJCA;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;

public class EmbeddedJCAContainer
implements DeployableContainer {
    private EmbeddedJCA embedded = null;

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new DeploymentException("Could not deploy a null application");
        }
        if (!ResourceAdapterArchive.class.isInstance(archive)) {
            throw new DeploymentException("Could not deploy a non resource adapter application");
        }
        try {
            this.embedded.deploy((ResourceAdapterArchive)ResourceAdapterArchive.class.cast(archive));
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy the application", (Throwable)e);
        }
        catch (Throwable t) {
            throw new DeploymentException("Could not deploy the application: " + t.getMessage());
        }
        return new LocalMethodExecutor();
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new DeploymentException("Could not undeploy a null application");
        }
        if (!ResourceAdapterArchive.class.isInstance(archive)) {
            throw new DeploymentException("Could not undeploy a non resource adapter application");
        }
        try {
            this.embedded.undeploy((ResourceAdapterArchive)ResourceAdapterArchive.class.cast(archive));
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy the application", (Throwable)e);
        }
        catch (Throwable t) {
            throw new DeploymentException("Could not undeploy the application: " + t.getMessage());
        }
    }

    public void setup(Context context, Configuration configuration) {
    }

    public void start(Context context) throws LifecycleException {
        this.embedded = new EmbeddedJCA();
        try {
            this.embedded.startup();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start the EmbeddedJCA container", (Throwable)e);
        }
        catch (Throwable t) {
            throw new LifecycleException("Could not start the EmbeddedJCA container: " + t.getMessage());
        }
    }

    public void stop(Context context) throws LifecycleException {
        try {
            this.embedded.shutdown();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop the EmbeddedJCA container", (Throwable)e);
        }
        catch (Throwable t) {
            throw new LifecycleException("Could not stop the EmbeddedJCA container: " + t.getMessage());
        }
        this.embedded = null;
    }
}

