/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.embedded.arquillian;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;

public final class ArquillianJCATestUtils {
    public static ResourceAdapterArchive buidShrinkwrapRa(String archiveName, String packageName) throws Exception {
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)archiveName);
        JavaArchive ja = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(UUID.randomUUID().toString() + ".jar"));
        ja.addClasses(ArquillianJCATestUtils.getClasses(packageName));
        raa.addLibrary((Archive)ja);
        return raa;
    }

    public static ResourceAdapterArchive buildShrinkwrapJdbcLocal(String archiveName) throws Exception {
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)archiveName);
        JavaArchive ja = ArquillianJCATestUtils.buildShrinkwrapJdbcJar();
        raa.addLibrary((Archive)ja);
        raa.addManifestResource("jdbc/local/META-INF/ra.xml", "ra.xml");
        return raa;
    }

    public static ResourceAdapterArchive buildShrinkwrapJdbcXa(String archiveName) throws Exception {
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)archiveName);
        JavaArchive ja = ArquillianJCATestUtils.buildShrinkwrapJdbcJar();
        raa.addLibrary((Archive)ja);
        raa.addManifestResource("jdbc/xa/META-INF/ra.xml", "ra.xml");
        return raa;
    }

    private static JavaArchive buildShrinkwrapJdbcJar() throws ClassNotFoundException, IOException {
        String packageName = "org.jboss.jca.adapters";
        JavaArchive ja = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ironjacamar-jdbc.jar");
        ja.addClasses(ArquillianJCATestUtils.getClasses(packageName));
        ja.setManifest("jdbc/jar/META-INF/MANIFEST.MF");
        return ja;
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(ArquillianJCATestUtils.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ArquillianJCATestUtils.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

