/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.embedded;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.KernelFactory;
import com.github.fungal.api.configuration.DeploymentOrder;
import com.github.fungal.api.configuration.KernelConfiguration;
import com.github.fungal.api.events.EventListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jca.embedded.Embedded;
import org.jboss.jca.embedded.PostClassLoaderEventListener;
import org.jboss.jca.embedded.PreClassLoaderEventListener;
import org.jboss.jca.embedded.SecurityActions;
import org.jboss.jca.embedded.dsl.InputStreamDescriptor;
import org.jboss.jca.embedded.dsl.datasources10.api.DatasourcesDescriptor;
import org.jboss.jca.embedded.dsl.resourceadapters10.api.ResourceAdaptersDescriptor;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

class EmbeddedJCA
implements Embedded {
    private static final int BUFFER_SIZE = 4096;
    private static Logger log = Logger.getLogger(EmbeddedJCA.class);
    private final boolean fullProfile;
    private Kernel kernel;
    private List<File> shrinkwrapDeployments;
    private boolean started;

    EmbeddedJCA(boolean fullProfile) {
        this.fullProfile = fullProfile;
        this.shrinkwrapDeployments = null;
        this.started = false;
    }

    @Override
    public void startup() throws Throwable {
        if (this.started) {
            throw new IllegalStateException("Container already started");
        }
        ArrayList<String> order = new ArrayList<String>(3);
        order.add(".xml");
        order.add(".rar");
        order.add("-ra.xml");
        order.add("-ds.xml");
        boolean management = Boolean.valueOf(SecurityActions.getSystemProperty("ironjacamar.embedded.management", "false"));
        KernelConfiguration kernelConfiguration = new KernelConfiguration();
        kernelConfiguration = kernelConfiguration.name("iron.jacamar");
        kernelConfiguration = kernelConfiguration.home(null);
        kernelConfiguration = kernelConfiguration.classLoader(0);
        kernelConfiguration = kernelConfiguration.management(management);
        if (management) {
            kernelConfiguration = kernelConfiguration.usePlatformMBeanServer(true);
        }
        kernelConfiguration = kernelConfiguration.parallelDeploy(false);
        kernelConfiguration = kernelConfiguration.remoteAccess(false);
        kernelConfiguration = kernelConfiguration.hotDeployment(false);
        kernelConfiguration = kernelConfiguration.eventListener((EventListener)new PreClassLoaderEventListener());
        kernelConfiguration = kernelConfiguration.eventListener((EventListener)new PostClassLoaderEventListener());
        kernelConfiguration = kernelConfiguration.deploymentOrder(new DeploymentOrder(order));
        this.kernel = KernelFactory.create((KernelConfiguration)kernelConfiguration);
        this.kernel.startup();
        if (this.fullProfile) {
            this.deploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "naming.xml");
            this.deploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "transaction.xml");
            this.deploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "stdio.xml");
            this.deploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "jca.xml");
            this.deploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "ds.xml");
        }
        this.started = true;
    }

    @Override
    public void shutdown() throws Throwable {
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        if (this.shrinkwrapDeployments != null && this.shrinkwrapDeployments.size() > 0) {
            ArrayList<File> copy = new ArrayList<File>(this.shrinkwrapDeployments);
            for (File f : copy) {
                this.removeDeployment(f);
            }
        }
        if (this.fullProfile) {
            this.undeploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "ds.xml");
            this.undeploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "jca.xml");
            this.undeploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "stdio.xml");
            this.undeploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "transaction.xml");
            this.undeploy(SecurityActions.getClassLoader(EmbeddedJCA.class), "naming.xml");
        }
        this.kernel.shutdown();
        this.started = false;
    }

    @Override
    public <T> T lookup(String name, Class<T> expectedType) throws Throwable {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("ExpectedType is null");
        }
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        return (T)this.kernel.getBean(name, expectedType);
    }

    @Override
    public void deploy(URL url) throws Throwable {
        if (url == null) {
            throw new IllegalArgumentException("Url is null");
        }
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        log.debugf("Deploying: %s", (Object)url);
        this.kernel.getMainDeployer().deploy(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(Descriptor descriptor) throws Throwable {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor is null");
        }
        if (descriptor.getDescriptorName() == null) {
            throw new IllegalArgumentException("Descriptor name is null");
        }
        if (!(descriptor instanceof InputStreamDescriptor || descriptor instanceof DatasourcesDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.datasources11.api.DatasourcesDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.datasources12.api.DatasourcesDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.datasources13.api.DatasourcesDescriptor || descriptor instanceof ResourceAdaptersDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.resourceadapters11.api.ResourceAdaptersDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.resourceadapters12.api.ResourceAdaptersDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.resourceadapters13.api.ResourceAdaptersDescriptor)) {
            throw new IllegalArgumentException("Unsupported descriptor: " + descriptor.getClass().getName());
        }
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        File parentDirectory = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
        File descriptorFile = new File(parentDirectory, descriptor.getDescriptorName());
        if (descriptorFile.exists()) {
            this.recursiveDelete(descriptorFile);
        }
        FileOutputStream os = new FileOutputStream(descriptorFile);
        BufferedOutputStream bos = new BufferedOutputStream(os, 4096);
        try {
            descriptor.exportTo((OutputStream)bos);
            bos.flush();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        log.debugf("Deploying: %s", (Object)descriptorFile);
        this.kernel.getMainDeployer().deploy(descriptorFile.toURI().toURL());
    }

    @Override
    public void deploy(ResourceAdapterArchive raa) throws Throwable {
        if (raa == null) {
            throw new IllegalArgumentException("Url is null");
        }
        if (!raa.getName().endsWith(".rar")) {
            throw new IllegalArgumentException(raa.getName() + " doesn't end with .rar");
        }
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        File parentDirectory = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
        File raaFile = new File(parentDirectory, raa.getName());
        if (this.shrinkwrapDeployments != null && this.shrinkwrapDeployments.contains(raaFile)) {
            throw new IOException(raa.getName() + " already deployed");
        }
        if (raaFile.exists()) {
            this.recursiveDelete(raaFile);
        }
        ((ZipExporter)raa.as(ZipExporter.class)).exportTo(raaFile, true);
        if (this.shrinkwrapDeployments == null) {
            this.shrinkwrapDeployments = new ArrayList<File>(1);
        }
        this.shrinkwrapDeployments.add(raaFile);
        log.debugf("Deploying: %s", (Object)raaFile);
        this.kernel.getMainDeployer().deploy(raaFile.toURI().toURL());
    }

    private void deploy(ClassLoader cl, String name) throws Throwable {
        if (cl == null) {
            throw new IllegalArgumentException("ClassLoader is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        URL url = cl.getResource(name);
        if (url == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        log.debugf("Deploying: %s", (Object)url);
        this.kernel.getMainDeployer().deploy(url);
    }

    @Override
    public void undeploy(URL url) throws Throwable {
        if (url == null) {
            throw new IllegalArgumentException("Url is null");
        }
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        log.debugf("Undeploying: %s", (Object)url);
        this.kernel.getMainDeployer().undeploy(url);
    }

    @Override
    public void undeploy(Descriptor descriptor) throws Throwable {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor is null");
        }
        if (descriptor.getDescriptorName() == null) {
            throw new IllegalArgumentException("Descriptor name is null");
        }
        if (!(descriptor instanceof InputStreamDescriptor || descriptor instanceof DatasourcesDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.datasources11.api.DatasourcesDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.datasources12.api.DatasourcesDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.datasources13.api.DatasourcesDescriptor || descriptor instanceof ResourceAdaptersDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.resourceadapters11.api.ResourceAdaptersDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.resourceadapters12.api.ResourceAdaptersDescriptor || descriptor instanceof org.jboss.jca.embedded.dsl.resourceadapters13.api.ResourceAdaptersDescriptor)) {
            throw new IllegalArgumentException("Unsupported descriptor: " + descriptor.getClass().getName());
        }
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        File parentDirectory = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
        File descriptorFile = new File(parentDirectory, descriptor.getDescriptorName());
        log.debugf("Undeploying: %s", (Object)descriptorFile);
        this.kernel.getMainDeployer().undeploy(descriptorFile.toURI().toURL());
        this.recursiveDelete(descriptorFile);
    }

    @Override
    public void undeploy(ResourceAdapterArchive raa) throws Throwable {
        if (raa == null) {
            throw new IllegalArgumentException("Url is null");
        }
        if (!this.started) {
            throw new IllegalStateException("Container not started");
        }
        File parentDirectory = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
        File raaFile = new File(parentDirectory, raa.getName());
        log.debugf("Undeploying: %s", (Object)raaFile);
        if (this.shrinkwrapDeployments == null || !this.shrinkwrapDeployments.contains(raaFile)) {
            throw new IOException(raa.getName() + " not deployed");
        }
        this.kernel.getMainDeployer().undeploy(raaFile.toURI().toURL());
        this.removeDeployment(raaFile);
    }

    private void undeploy(ClassLoader cl, String name) throws Throwable {
        if (cl == null) {
            throw new IllegalArgumentException("ClassLoader is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        URL url = cl.getResource(name);
        log.debugf("Undeploying: %s", (Object)url);
        this.kernel.getMainDeployer().undeploy(url);
    }

    private void removeDeployment(File deployment) throws IOException {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.exists()) {
            this.shrinkwrapDeployments.remove(deployment);
            if (this.shrinkwrapDeployments.size() == 0) {
                this.shrinkwrapDeployments = null;
            }
            this.recursiveDelete(deployment);
        }
    }

    private void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.recursiveDelete(files[i]);
                        continue;
                    }
                    Files.delete(files[i].toPath());
                }
            }
            Files.delete(f.toPath());
        }
    }
}

