/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.embedded;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.KernelFactory;
import com.github.fungal.api.configuration.KernelConfiguration;
import com.github.fungal.api.events.EventListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jca.embedded.PostClassLoaderEventListener;
import org.jboss.jca.embedded.PreClassLoaderEventListener;
import org.jboss.jca.embedded.SecurityActions;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;

public class EmbeddedJCA {
    private boolean fullProfile;
    private Kernel kernel;
    private List<File> shrinkwrapDeployments;

    public EmbeddedJCA() {
        this(true);
    }

    public EmbeddedJCA(boolean fullProfile) {
        this.fullProfile = fullProfile;
        this.shrinkwrapDeployments = null;
    }

    public void startup() throws Throwable {
        KernelConfiguration kernelConfiguration = new KernelConfiguration();
        kernelConfiguration = kernelConfiguration.name("iron.jacamar");
        kernelConfiguration = kernelConfiguration.home(null);
        kernelConfiguration = kernelConfiguration.classLoader(0);
        kernelConfiguration = kernelConfiguration.parallelDeploy(false);
        kernelConfiguration = kernelConfiguration.remoteAccess(false);
        kernelConfiguration = kernelConfiguration.hotDeployment(false);
        kernelConfiguration = kernelConfiguration.eventListener((EventListener)new PreClassLoaderEventListener());
        kernelConfiguration = kernelConfiguration.eventListener((EventListener)new PostClassLoaderEventListener());
        this.kernel = KernelFactory.create((KernelConfiguration)kernelConfiguration);
        this.kernel.startup();
        if (this.fullProfile) {
            this.deploy(EmbeddedJCA.class.getClassLoader(), "naming.xml");
            this.deploy(EmbeddedJCA.class.getClassLoader(), "transaction.xml");
            this.deploy(EmbeddedJCA.class.getClassLoader(), "stdio.xml");
            this.deploy(EmbeddedJCA.class.getClassLoader(), "jca.xml");
        }
    }

    public void shutdown() throws Throwable {
        if (this.shrinkwrapDeployments != null && this.shrinkwrapDeployments.size() > 0) {
            ArrayList<File> copy = new ArrayList<File>(this.shrinkwrapDeployments);
            for (File f : copy) {
                this.removeDeployment(f);
            }
        }
        if (this.fullProfile) {
            this.undeploy(EmbeddedJCA.class.getClassLoader(), "jca.xml");
            this.undeploy(EmbeddedJCA.class.getClassLoader(), "stdio.xml");
            this.undeploy(EmbeddedJCA.class.getClassLoader(), "transaction.xml");
            this.undeploy(EmbeddedJCA.class.getClassLoader(), "naming.xml");
        }
        this.kernel.shutdown();
    }

    public <T> T lookup(String name, Class<T> expectedType) throws Throwable {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("ExpectedType is null");
        }
        return (T)this.kernel.getBean(name, expectedType);
    }

    public void deploy(URL url) throws Throwable {
        if (url == null) {
            throw new IllegalArgumentException("Url is null");
        }
        this.kernel.getMainDeployer().deploy(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(ResourceAdapterArchive raa) throws Throwable {
        if (raa == null) {
            throw new IllegalArgumentException("Url is null");
        }
        if (!raa.getName().endsWith(".rar")) {
            throw new IllegalArgumentException(raa.getName() + " doesn't end with .rar");
        }
        InputStream is = ((ZipExporter)raa.as(ZipExporter.class)).exportZip();
        File parentDirectory = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
        File raaFile = new File(parentDirectory, raa.getName());
        if (this.shrinkwrapDeployments != null && this.shrinkwrapDeployments.contains(raaFile)) {
            throw new IOException(raa.getName() + " already deployed");
        }
        if (raaFile.exists()) {
            this.recursiveDelete(raaFile);
        }
        FileOutputStream os = new FileOutputStream(raaFile);
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.flush();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ignore) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (this.shrinkwrapDeployments == null) {
            this.shrinkwrapDeployments = new ArrayList<File>(1);
        }
        this.shrinkwrapDeployments.add(raaFile);
        this.kernel.getMainDeployer().deploy(raaFile.toURI().toURL());
    }

    public void deploy(ClassLoader cl, String name) throws Throwable {
        if (cl == null) {
            throw new IllegalArgumentException("ClassLoader is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        URL url = cl.getResource(name);
        this.kernel.getMainDeployer().deploy(url);
    }

    public void deploy(Class<?> clz) throws Throwable {
        if (clz == null) {
            throw new IllegalArgumentException("Clz is null");
        }
        String name = clz.getName().replace('.', '/');
        name = name + "-jboss-beans.xml";
        URL url = clz.getClassLoader().getResource(name);
        this.kernel.getMainDeployer().deploy(url);
    }

    public void undeploy(URL url) throws Throwable {
        if (url == null) {
            throw new IllegalArgumentException("Url is null");
        }
        this.kernel.getMainDeployer().undeploy(url);
    }

    public void undeploy(ResourceAdapterArchive raa) throws Throwable {
        if (raa == null) {
            throw new IllegalArgumentException("Url is null");
        }
        File parentDirectory = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
        File raaFile = new File(parentDirectory, raa.getName());
        if (!this.shrinkwrapDeployments.contains(raaFile)) {
            throw new IOException(raa.getName() + " not deployed");
        }
        this.kernel.getMainDeployer().undeploy(raaFile.toURI().toURL());
        this.removeDeployment(raaFile);
    }

    public void undeploy(ClassLoader cl, String name) throws Throwable {
        if (cl == null) {
            throw new IllegalArgumentException("ClassLoader is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        URL url = cl.getResource(name);
        this.kernel.getMainDeployer().undeploy(url);
    }

    public void undeploy(Class<?> clz) throws Throwable {
        if (clz == null) {
            throw new IllegalArgumentException("Clz is null");
        }
        String name = clz.getName().replace('.', '/');
        name = name + "-jboss-beans.xml";
        URL url = clz.getClassLoader().getResource(name);
        this.kernel.getMainDeployer().undeploy(url);
    }

    private void removeDeployment(File deployment) throws IOException {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.exists()) {
            this.shrinkwrapDeployments.remove(deployment);
            if (this.shrinkwrapDeployments.size() == 0) {
                this.shrinkwrapDeployments = null;
            }
            this.recursiveDelete(deployment);
        }
    }

    private void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }
}

