/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.embedded.dsl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExportException;

public class InputStreamDescriptor
implements Descriptor {
    private final String name;
    private final InputStream is;

    public InputStreamDescriptor(String name, InputStream is) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null");
        }
        this.name = name;
        this.is = is;
    }

    public String getDescriptorName() {
        return this.name;
    }

    public String exportAsString() throws DescriptorExportException {
        try {
            StringBuilder sb = new StringBuilder();
            int read = 0;
            while ((read = this.is.read()) != -1) {
                sb = sb.append((char)read);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new DescriptorExportException("Error during exportAsString: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException ioe) {}
        }
    }

    public void exportTo(OutputStream output) throws DescriptorExportException, IllegalArgumentException {
        if (output == null) {
            throw new IllegalArgumentException("Output is null");
        }
        try {
            int read = 0;
            while ((read = this.is.read()) != -1) {
                output.write(read);
            }
            output.flush();
        }
        catch (IOException ioe) {
            throw new DescriptorExportException("Error during exportTo: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException ioe) {}
        }
    }
}

