package org.jboss.jca.embedded.dsl.ironjacamar11.impl; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.jca.embedded.dsl.ironjacamar11.api.WorkmanagerSecurityMappingsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.jca.embedded.dsl.ironjacamar11.api.WorkmanagerSecurityMappingsUsersType;
import org.jboss.jca.embedded.dsl.ironjacamar11.impl.WorkmanagerSecurityMappingsUsersTypeImpl;
import org.jboss.jca.embedded.dsl.ironjacamar11.api.WorkmanagerSecurityMappingsGroupsType;
import org.jboss.jca.embedded.dsl.ironjacamar11.impl.WorkmanagerSecurityMappingsGroupsTypeImpl;

/**
 * This class implements the <code> workmanagerSecurityMappingsType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @since Generation date :2013-02-28T09:43:11.119-05:00
 */
public class WorkmanagerSecurityMappingsTypeImpl<T> implements Child<T>, WorkmanagerSecurityMappingsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WorkmanagerSecurityMappingsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WorkmanagerSecurityMappingsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityMappingsType ElementName: ironjacamar:workmanagerSecurityMappingsUsersType ElementType : users
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>users</code> element with the given value will be created.
    * Otherwise, the existing <code>users</code> element will be returned.
    * @return  a new or existing instance of <code>WorkmanagerSecurityMappingsUsersType<WorkmanagerSecurityMappingsType<T>></code> 
    */
   public WorkmanagerSecurityMappingsUsersType<WorkmanagerSecurityMappingsType<T>> getOrCreateUsers()
   {
      Node node = childNode.getOrCreate("users");
      WorkmanagerSecurityMappingsUsersType<WorkmanagerSecurityMappingsType<T>> users = new WorkmanagerSecurityMappingsUsersTypeImpl<WorkmanagerSecurityMappingsType<T>>(this, "users", childNode, node);
      return users;
   }

   /**
    * Removes the <code>users</code> element 
    * @return the current instance of <code>WorkmanagerSecurityMappingsType<T></code> 
    */
   public WorkmanagerSecurityMappingsType<T> removeUsers()
   {
      childNode.removeChildren("users");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WorkmanagerSecurityMappingsType ElementName: ironjacamar:workmanagerSecurityMappingsGroupsType ElementType : groups
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>groups</code> element with the given value will be created.
    * Otherwise, the existing <code>groups</code> element will be returned.
    * @return  a new or existing instance of <code>WorkmanagerSecurityMappingsGroupsType<WorkmanagerSecurityMappingsType<T>></code> 
    */
   public WorkmanagerSecurityMappingsGroupsType<WorkmanagerSecurityMappingsType<T>> getOrCreateGroups()
   {
      Node node = childNode.getOrCreate("groups");
      WorkmanagerSecurityMappingsGroupsType<WorkmanagerSecurityMappingsType<T>> groups = new WorkmanagerSecurityMappingsGroupsTypeImpl<WorkmanagerSecurityMappingsType<T>>(this, "groups", childNode, node);
      return groups;
   }

   /**
    * Removes the <code>groups</code> element 
    * @return the current instance of <code>WorkmanagerSecurityMappingsType<T></code> 
    */
   public WorkmanagerSecurityMappingsType<T> removeGroups()
   {
      childNode.removeChildren("groups");
      return this;
   }
}
