/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.junit.InSequenceSorter;
import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptorBuilder;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arquillian
extends BlockJUnit4ClassRunner {
    public Arquillian(Class<?> klass) throws InitializationError {
        super(klass);
        State.runnerStarted();
    }

    protected List<FrameworkMethod> getChildren() {
        List children = super.getChildren();
        boolean hasDefinedOrder = false;
        for (FrameworkMethod method : children) {
            if (method.getAnnotation(InSequence.class) == null) continue;
            hasDefinedOrder = true;
        }
        if (hasDefinedOrder) {
            Collections.sort(children, new InSequenceSorter());
        }
        return children;
    }

    public void run(RunNotifier notifier) {
        if (!State.hasTestAdaptor()) {
            if (State.hasInitializationException()) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Arquillian has previously been attempted initialized, but failed. See cause for previous exception", State.getInitializationException())));
            } else {
                TestRunnerAdaptor adaptor = TestRunnerAdaptorBuilder.build();
                try {
                    adaptor.beforeSuite();
                    State.testAdaptor(adaptor);
                }
                catch (Exception e) {
                    State.caughtInitializationException(e);
                    notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
                }
            }
        }
        notifier.addListener(new RunListener(){

            public void testRunFinished(Result result) throws Exception {
                State.runnerFinished();
                this.shutdown();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void shutdown() {
                block6: {
                    try {
                        if (!State.isLastRunner()) break block6;
                        try {
                            if (State.hasTestAdaptor()) {
                                TestRunnerAdaptor adaptor = State.getTestAdaptor();
                                adaptor.afterSuite();
                                adaptor.shutdown();
                            }
                        }
                        finally {
                            State.clean();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not run @AfterSuite", e);
                    }
                }
            }
        });
        if (State.hasTestAdaptor()) {
            super.run(notifier);
        }
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected Statement withBeforeClasses(final Statement originalStatement) {
        final Statement onlyBefores = super.withBeforeClasses((Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                State.getTestAdaptor().beforeClass(Arquillian.this.getTestClass().getJavaClass(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyBefores));
                originalStatement.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(final Statement originalStatement) {
        final Statement onlyAfters = super.withAfterClasses((Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.multiExecute(new Statement[]{originalStatement, new Statement(){

                    public void evaluate() throws Throwable {
                        State.getTestAdaptor().afterClass(Arquillian.this.getTestClass().getJavaClass(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyAfters));
                    }
                }});
            }
        };
    }

    protected Statement withBefores(final FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyBefores = super.withBefores(method, target, (Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                State.getTestAdaptor().before(target, method.getMethod(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyBefores));
                originalStatement.evaluate();
            }
        };
    }

    protected Statement withAfters(final FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyAfters = super.withAfters(method, target, (Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Arquillian.this.multiExecute(new Statement[]{originalStatement, new Statement(){

                    public void evaluate() throws Throwable {
                        State.getTestAdaptor().after(target, method.getMethod(), (LifecycleMethodExecutor)new StatementLifecycleExecutor(onlyAfters));
                    }
                }});
            }
        };
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestResult result = State.getTestAdaptor().test(new TestMethodExecutor(){

                    public void invoke(Object ... parameters) throws Throwable {
                        try {
                            method.invokeExplosively(test, parameters);
                        }
                        catch (Throwable e) {
                            State.caughtTestException(e);
                            throw e;
                        }
                    }

                    public Method getMethod() {
                        return method.getMethod();
                    }

                    public Object getInstance() {
                        return test;
                    }
                });
                if (result.getThrowable() != null) {
                    throw result.getThrowable();
                }
            }
        };
    }

    private void multiExecute(Statement ... statements) throws Throwable {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Statement command : statements) {
            try {
                command.evaluate();
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        if (exceptions.size() == 1) {
            throw (Throwable)exceptions.get(0);
        }
        throw new MultipleFailureException(exceptions);
    }

    private static class StatementLifecycleExecutor
    implements LifecycleMethodExecutor {
        private Statement statement;

        public StatementLifecycleExecutor(Statement statement) {
            this.statement = statement;
        }

        public void invoke() throws Throwable {
            this.statement.evaluate();
        }
    }

    private static class EmptyStatement
    extends Statement {
        private EmptyStatement() {
        }

        public void evaluate() throws Throwable {
        }
    }
}

