/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import org.jboss.arquillian.test.spi.TestRunnerAdaptor;

public class State {
    private static ThreadLocal<Throwable> caughtTestException = new ThreadLocal();
    private static ThreadLocal<Throwable> caughtInitializationException = new ThreadLocal();
    private static ThreadLocal<Integer> lastCreatedRunner = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Integer(0);
        }
    };
    private static ThreadLocal<TestRunnerAdaptor> deployableTest = new ThreadLocal();

    static void runnerStarted() {
        lastCreatedRunner.set(lastCreatedRunner.get() + 1);
    }

    static Integer runnerFinished() {
        Integer currentCount = lastCreatedRunner.get() - 1;
        lastCreatedRunner.set(currentCount);
        return currentCount;
    }

    static Integer runnerCurrent() {
        return lastCreatedRunner.get();
    }

    static boolean isLastRunner() {
        return State.runnerCurrent() == 0;
    }

    static void testAdaptor(TestRunnerAdaptor adaptor) {
        deployableTest.set(adaptor);
    }

    static boolean hasTestAdaptor() {
        return State.getTestAdaptor() != null;
    }

    static TestRunnerAdaptor getTestAdaptor() {
        return deployableTest.get();
    }

    static void caughtInitializationException(Throwable throwable) {
        caughtInitializationException.set(throwable);
    }

    static boolean hasInitializationException() {
        return State.getInitializationException() != null;
    }

    static Throwable getInitializationException() {
        return caughtInitializationException.get();
    }

    public static void caughtTestException(Throwable throwable) {
        if (throwable == null) {
            caughtTestException.remove();
        } else {
            caughtTestException.set(throwable);
        }
    }

    public static boolean hasTestException() {
        return State.getTestException() != null;
    }

    public static Throwable getTestException() {
        return caughtTestException.get();
    }

    static void clean() {
        lastCreatedRunner.remove();
        deployableTest.remove();
        caughtInitializationException.remove();
    }
}

