/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.JDocBookComponentRegistry;

public class ClasspathResolver
implements URIResolver {
    public static final String SCHEME = "classpath:";
    private final JDocBookComponentRegistry componentRegistry;

    public ClasspathResolver(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (!href.startsWith(SCHEME)) {
            return null;
        }
        try {
            URL url = this.componentRegistry.getEnvironment().getResourceDelegate().locateResource(href);
            if (url != null) {
                return new StreamSource(url.openStream(), url.toExternalForm());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new TransformerException("Unable to resolve requested classpath URL [" + href + "]");
    }
}

