/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.classloader;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.impl.classloader.ExportClassLoaderRepository;
import com.github.fungal.impl.classloader.SecurityActions;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

class ArchiveClassLoader
extends KernelClassLoader {
    private Integer id;
    private Set<String> exportPackages;
    private Set<Integer> importClassLoaders;
    private ExportClassLoaderRepository eclr;

    ArchiveClassLoader(Integer id, URL url, Set<String> exportPackages, ExportClassLoaderRepository eclr) {
        super(new URL[]{url}, SecurityActions.getSystemClassLoader());
        if (id == null) {
            throw new IllegalArgumentException("Id is null");
        }
        if (url == null) {
            throw new IllegalArgumentException("Url is null");
        }
        if (exportPackages == null) {
            throw new IllegalArgumentException("ExportPackages is null");
        }
        if (eclr == null) {
            throw new IllegalArgumentException("ECLR is null");
        }
        this.id = id;
        this.exportPackages = exportPackages;
        this.eclr = eclr;
    }

    Integer getId() {
        return this.id;
    }

    void addImportClassLoader(Integer id) {
        if (this.importClassLoaders == null) {
            this.importClassLoaders = new HashSet<Integer>(1);
        }
        this.importClassLoaders.add(id);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isClassRegistered(name)) {
            return this.loadClass(name, false);
        }
        try {
            return Class.forName(name, true, SecurityActions.getSystemClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            if (this.importClassLoaders != null) {
                for (Integer id : this.importClassLoaders) {
                    ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                    if (acl == null) continue;
                    try {
                        return acl.lookup(name);
                    }
                    catch (ClassNotFoundException ignore) {
                    }
                }
            }
            return this.eclr.getNonExportClassLoader().lookup(name);
        }
    }

    public Class<?> lookup(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.isClassRegistered(name)) {
            return this.findClass(name, true);
        }
        throw new ClassNotFoundException("Unable to load class: " + name);
    }

    public Class<?> findClass(String name, boolean fullScan) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (Throwable t) {
            if (fullScan && this.importClassLoaders != null) {
                for (Integer id : this.importClassLoaders) {
                    ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                    if (acl == null) continue;
                    try {
                        return acl.findClass(name, false);
                    }
                    catch (ClassNotFoundException ignore) {
                    }
                }
            }
            throw new ClassNotFoundException("Unable to load class: " + name);
        }
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        if (this.isClassRegistered(className)) {
            super.setClassAssertionStatus(className, enabled);
        }
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        if (this.isPackageRegistered(packageName)) {
            super.setPackageAssertionStatus(packageName, enabled);
        }
    }

    private boolean isClassRegistered(String name) {
        String packageName = "";
        int lastDot = name.lastIndexOf(".");
        if (lastDot != -1) {
            packageName = name.substring(0, lastDot);
        }
        return this.exportPackages.contains(packageName);
    }

    private boolean isPackageRegistered(String name) {
        return this.exportPackages.contains(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArchiveClassLoader@").append(Integer.toHexString(System.identityHashCode(this)));
        sb = sb.append("[");
        sb = sb.append("Id=");
        sb = sb.append(this.id);
        sb = sb.append(",");
        sb = sb.append("Url=");
        sb = sb.append(super.getURLs()[0]);
        sb = sb.append(",");
        sb = sb.append("ExportPackages=");
        sb = sb.append(this.exportPackages);
        sb = sb.append(",");
        sb = sb.append("ImportClassLoaders=");
        sb = sb.append(this.importClassLoaders);
        sb = sb.append(",");
        sb = sb.append("ExportClassLoaderRepository=");
        sb = sb.append(Integer.toHexString(System.identityHashCode(this.eclr)));
        sb = sb.append("]");
        return sb.toString();
    }
}

