/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.ScriptRepository;
import org.jboss.byteman.agent.Transform;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.modules.ModuleSystem;
import org.jboss.byteman.rule.helper.Helper;

public class Retransformer
extends Transformer {
    private Set<String> sysJars = new HashSet<String>();
    private Set<String> bootJars = new HashSet<String>();

    public Retransformer(Instrumentation inst, ModuleSystem moduleSystem, List<String> scriptPaths, List<String> scriptTexts, boolean isRedefine) throws Exception {
        super(inst, moduleSystem, scriptPaths, scriptTexts, isRedefine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installScript(List<String> scriptTexts, List<String> scriptNames, PrintWriter out) throws Exception {
        int length = scriptTexts.size();
        LinkedList<RuleScript> toBeAdded = new LinkedList<RuleScript>();
        LinkedList<RuleScript> toBeRemoved = new LinkedList<RuleScript>();
        for (int i = 0; i < length; ++i) {
            String string = scriptTexts.get(i);
            String string2 = scriptNames.get(i);
            List<RuleScript> list = this.scriptRepository.processScripts(string, string2);
            toBeAdded.addAll(list);
        }
        for (RuleScript ruleScript : toBeAdded) {
            RuleScript previous;
            String string = ruleScript.getName();
            String string3 = ruleScript.getTargetClass();
            Object baseName = null;
            int lastDotIdx = string3.lastIndexOf(46);
            if (lastDotIdx >= 0) {
                baseName = string3.substring(lastDotIdx + 1);
            }
            if ((previous = this.scriptRepository.addScript(ruleScript)) != null) {
                out.println("redefine rule " + string);
                toBeRemoved.add(previous);
                continue;
            }
            out.println("install rule " + string);
        }
        LinkedList<String> deletedClassNames = new LinkedList<String>();
        for (RuleScript ruleScript : toBeRemoved) {
            List<Transform> list = ruleScript.getTransformed();
            for (Transform transform : list) {
                String className = transform.getInternalClassName();
                if (deletedClassNames.contains(className)) continue;
                deletedClassNames.add(className);
            }
        }
        ScriptRepository scriptRepository = new ScriptRepository(this.skipOverrideRules());
        for (RuleScript ruleScript : toBeAdded) {
            scriptRepository.addScript(ruleScript);
        }
        LinkedList<Class> linkedList = new LinkedList<Class>();
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            if (this.isSkipClass(clazz)) continue;
            if (deletedClassNames.contains(clazz.getName())) {
                linkedList.add(clazz);
                continue;
            }
            if (!scriptRepository.matchClass(clazz)) continue;
            linkedList.add(clazz);
        }
        if (!linkedList.isEmpty()) {
            Class[] classArray = new Class[linkedList.size()];
            linkedList.toArray(classArray);
            for (int i = 0; i < linkedList.size(); ++i) {
                Helper.verbose("retransforming " + classArray[i].getName());
            }
            Retransformer i = this;
            synchronized (i) {
                try {
                    this.inst.retransformClasses(classArray);
                }
                catch (VerifyError ve) {
                    Helper.err("Retransformer : VerifyError during retransformation : some rules may not have been correctly injected or uninjected!");
                    Helper.errTraceException(ve);
                    out.println("VerifyError during retransformation : some rules may not have been correctly injected or uninjected!");
                    ve.printStackTrace(out);
                }
            }
        }
        for (RuleScript ruleScript : toBeRemoved) {
            ruleScript.purge();
        }
    }

    protected void collectAffectedNames(List<RuleScript> ruleScripts, List<String> classList, List<String> interfaceList, List<String> superClassList, List<String> superInterfaceList) {
        for (RuleScript ruleScript : ruleScripts) {
            String targetClassName = ruleScript.getTargetClass();
            boolean isOverride = ruleScript.isOverride();
            if (ruleScript.isInterface()) {
                if (interfaceList.contains(targetClassName)) continue;
                interfaceList.add(targetClassName);
                if (!isOverride) continue;
                superInterfaceList.add(targetClassName);
                continue;
            }
            if (classList.contains(targetClassName)) continue;
            classList.add(targetClassName);
            if (!isOverride) continue;
            superClassList.add(targetClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listScripts(PrintWriter out) throws Exception {
        Iterator<RuleScript> iterator = this.scriptRepository.currentRules().iterator();
        if (!iterator.hasNext()) {
            out.println("no rules installed");
        } else {
            while (iterator.hasNext()) {
                RuleScript ruleScript = iterator.next();
                ruleScript.writeTo(out);
                RuleScript ruleScript2 = ruleScript;
                synchronized (ruleScript2) {
                    List<Transform> transformed = ruleScript.getTransformed();
                    if (transformed != null) {
                        for (Transform transform : transformed) {
                            transform.writeTo(out);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeScripts(List<String> scriptTexts, PrintWriter out) throws Exception {
        List<Object> toBeRemoved;
        if (scriptTexts != null) {
            void var5_7;
            toBeRemoved = new LinkedList();
            int length = scriptTexts.size();
            boolean bl = false;
            while (var5_7 < length) {
                Class[] scriptText = scriptTexts.get((int)var5_7);
                String[] stringArray = scriptText.split("\n");
                for (int j = 0; j < stringArray.length; ++j) {
                    String line = stringArray[j].trim();
                    if (!line.startsWith("RULE ")) continue;
                    String name = line.substring(5).trim();
                    RuleScript ruleScript = this.scriptRepository.scriptForRuleName(name);
                    if (ruleScript == null) {
                        out.print("ERROR failed to find loaded rule with name ");
                        out.println(name);
                        continue;
                    }
                    if (toBeRemoved.contains(ruleScript)) {
                        out.print("WARNING duplicate occurence for rule name ");
                        out.println(name);
                        continue;
                    }
                    toBeRemoved.add(ruleScript);
                }
                ++var5_7;
            }
        } else {
            toBeRemoved = this.scriptRepository.currentRules();
        }
        if (toBeRemoved.isEmpty()) {
            out.println("ERROR No rule scripts to remove");
            return;
        }
        for (RuleScript ruleScript : toBeRemoved) {
            if (this.scriptRepository.removeScript(ruleScript) == ruleScript) continue;
            out.println("ERROR remove failed to find script " + ruleScript.getName());
        }
        LinkedList<Class> transformed = new LinkedList<Class>();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (RuleScript ruleScript : toBeRemoved) {
            List<Transform> transforms = ruleScript.getTransformed();
            if (transforms == null) continue;
            for (Transform transform : transforms) {
                String className = transform.getInternalClassName();
                if (linkedList.contains(className)) continue;
                linkedList.add(className);
            }
        }
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            if (this.isSkipClass(clazz) || !linkedList.contains(clazz.getName())) continue;
            transformed.add(clazz);
        }
        if (!transformed.isEmpty()) {
            void var7_16;
            Class[] transformedArray = new Class[transformed.size()];
            transformed.toArray(transformedArray);
            boolean bl = false;
            while (var7_16 < transformed.size()) {
                Helper.verbose("retransforming " + transformedArray[var7_16].getName());
                ++var7_16;
            }
            try {
                this.inst.retransformClasses(transformedArray);
            }
            catch (VerifyError verifyError) {
                Helper.err("Retransformer : VerifyError during retransformation : some rules may not have been correctly uninjected!");
                Helper.errTraceException(verifyError);
                out.println("VerifyError during retransformation : some rules may not have been correctly uninjected!");
                verifyError.printStackTrace(out);
            }
        }
        for (RuleScript ruleScript : toBeRemoved) {
            ruleScript.purge();
            out.println("uninstall RULE " + ruleScript.getName());
        }
    }

    public void appendJarFile(PrintWriter out, JarFile jarfile, boolean isBoot) throws Exception {
        if (isBoot) {
            this.inst.appendToBootstrapClassLoaderSearch(jarfile);
            this.bootJars.add(jarfile.getName());
            out.println("append boot jar " + jarfile.getName());
        } else {
            this.inst.appendToSystemClassLoaderSearch(jarfile);
            this.sysJars.add(jarfile.getName());
            out.println("append sys jar " + jarfile.getName());
        }
    }

    public Set<String> getLoadedBootJars() {
        return new HashSet<String>(this.bootJars);
    }

    public Set<String> getLoadedSystemJars() {
        return new HashSet<String>(this.sysJars);
    }
}

