/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.agent.adapter.RuleGeneratorAdapter;
import org.jboss.byteman.agent.adapter.cfg.CFG;
import org.jboss.byteman.agent.adapter.cfg.CodeLocation;
import org.jboss.byteman.agent.adapter.cfg.TriggerDetails;
import org.jboss.byteman.agent.adapter.cfg.TryCatchDetails;
import org.jboss.byteman.objectweb.asm.Handle;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.objectweb.asm.commons.Method;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.helper.Helper;
import org.jboss.byteman.rule.type.TypeHelper;

public class RuleTriggerMethodAdapter
extends RuleGeneratorAdapter {
    private RuleScript ruleScript;
    private String signature;
    protected String[] exceptions;
    private Type[] argumentTypes;
    private Type saveValueType;
    private int[] argLocalIndices;
    private List<Binding> callArrayBindings;
    private boolean bindReturnOrThrowableValue;
    private boolean bindInvokeParams;
    private boolean bindingIndicesSet;
    private Type returnBindingType;
    private CFG cfg;

    RuleTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
        super(mv, transformContext, access, name, descriptor, transformContext.lookupRule(name, descriptor));
        this.signature = signature;
        this.exceptions = exceptions;
        this.callArrayBindings = new ArrayList<Binding>();
        this.returnBindingType = Type.getReturnType(descriptor);
        this.argumentTypes = Type.getArgumentTypes(descriptor);
        this.argLocalIndices = new int[this.argumentTypes.length];
        this.bindReturnOrThrowableValue = false;
        this.bindInvokeParams = false;
        this.bindingIndicesSet = false;
    }

    public Type[] getInvokedTypes() {
        throw new RuntimeException("RuleTriggerMethodAdapter.getInvokedTypes() : should never get called!");
    }

    public Type getReturnBindingType() {
        return this.returnBindingType;
    }

    private void setBindingIndices() {
        if (this.bindingIndicesSet) {
            return;
        }
        Bindings bindings = this.rule.getBindings();
        Iterator<Binding> iterator = bindings.iterator();
        ArrayList<Binding> aliasBindings = new ArrayList<Binding>();
        int argLocalIndex = 0;
        if ((this.access & 8) == 0) {
            ++argLocalIndex;
        }
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.argLocalIndices[i] = argLocalIndex;
            argLocalIndex += this.argumentTypes[i].getSize();
        }
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            if (!binding.isLocalVar()) continue;
            int localIdx = binding.getLocalIndex();
            if (localIdx < argLocalIndex) {
                if ((binding = this.alias(binding, bindings, localIdx)) == null) continue;
                aliasBindings.add(binding);
                continue;
            }
            this.callArrayBindings.add(binding);
        }
        bindings.addBindings(aliasBindings);
        iterator = bindings.iterator();
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            if (binding.isParam()) {
                this.callArrayBindings.add(binding);
                continue;
            }
            if (binding.isReturn()) {
                this.bindReturnOrThrowableValue = true;
                this.saveValueType = this.getReturnBindingType();
                binding.setDescriptor(this.saveValueType.getClassName());
                this.callArrayBindings.add(binding);
                continue;
            }
            if (binding.isThrowable()) {
                this.bindReturnOrThrowableValue = true;
                this.saveValueType = Type.getType("Ljava/lang/Throwable;");
                this.callArrayBindings.add(binding);
                continue;
            }
            if (binding.isParamCount() || binding.isParamArray()) {
                this.callArrayBindings.add(binding);
                continue;
            }
            if (binding.isInvokeParamArray()) {
                this.callArrayBindings.add(binding);
                this.bindInvokeParams = true;
                continue;
            }
            if (!binding.isTriggerClass() && !binding.isTriggerMethod()) continue;
            this.callArrayBindings.add(binding);
            binding.setDescriptor("java.lang.String");
        }
        Comparator<Binding> comparator = new Comparator<Binding>(){

            @Override
            public int compare(Binding b1, Binding b2) {
                if (b1.isParam()) {
                    if (b2.isParam()) {
                        int i2;
                        int i1 = b1.getIndex();
                        return i1 < (i2 = b2.getIndex()) ? -1 : (i1 > i2 ? 1 : 0);
                    }
                    return -1;
                }
                if (b1.isLocalVar()) {
                    if (b2.isParam()) {
                        return 1;
                    }
                    if (b2.isLocalVar()) {
                        int i2;
                        int i1 = b1.getLocalIndex();
                        return i1 < (i2 = b2.getLocalIndex()) ? -1 : (i1 > i2 ? 1 : 0);
                    }
                    return -1;
                }
                if (b1.isParamCount()) {
                    if (b2.isParam() || b2.isLocalVar()) {
                        return 1;
                    }
                    if (b2.isParamCount()) {
                        return 0;
                    }
                    return -1;
                }
                if (b1.isParamArray()) {
                    if (b2.isParam() || b2.isLocalVar() || b2.isParamCount()) {
                        return 1;
                    }
                    if (b2.isParamArray()) {
                        return 0;
                    }
                    return -1;
                }
                if (b1.isInvokeParamArray()) {
                    if (b2.isParam() || b2.isLocalVar() || b2.isParamCount() || b2.isParamArray()) {
                        return 1;
                    }
                    if (b2.isInvokeParamArray()) {
                        return 0;
                    }
                    return -1;
                }
                if (b1.isTriggerClass()) {
                    if (b2.isParam() || b2.isLocalVar() || b2.isParamCount() || b2.isParamArray() || b2.isInvokeParamArray()) {
                        return 1;
                    }
                    if (b2.isTriggerClass()) {
                        return 0;
                    }
                    return -1;
                }
                if (b1.isTriggerMethod()) {
                    if (b2.isParam() || b2.isLocalVar() || b2.isParamCount() || b2.isParamArray() || b2.isInvokeParamArray() || b2.isTriggerClass()) {
                        return 1;
                    }
                    if (b2.isTriggerMethod()) {
                        return 0;
                    }
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(this.callArrayBindings, comparator);
        int n = this.callArrayBindings.size();
        for (int i = 0; i < n; ++i) {
            this.callArrayBindings.get(i).setCallArrayIndex(i);
        }
        this.bindingIndicesSet = true;
    }

    private Binding alias(Binding binding, Bindings bindings, int localIdx) {
        if ((this.access & 8) == 0 && localIdx == 0) {
            String name = "$0";
            Binding alias = bindings.lookup(name);
            if (alias == null) {
                alias = new Binding(this.rule, name);
                alias.setDescriptor(binding.getDescriptor());
                alias.setLocalIndex(binding.getLocalIndex());
                binding.aliasTo(alias);
                return alias;
            }
            binding.aliasTo(alias);
            return null;
        }
        for (int i = 0; i < this.argLocalIndices.length; ++i) {
            if (this.argLocalIndices[i] != localIdx) continue;
            String name = "$" + (i + 1);
            Binding alias = bindings.lookup(name);
            if (alias == null) {
                alias = new Binding(this.rule, name);
                alias.setDescriptor(binding.getDescriptor());
                alias.setLocalIndex(binding.getLocalIndex());
                binding.aliasTo(alias);
                return alias;
            }
            binding.aliasTo(alias);
            return null;
        }
        return null;
    }

    private int doReturnOrThrowSave() {
        int saveValueSlot = this.newLocal(this.saveValueType);
        if (this.saveValueType.getSize() == 2) {
            this.visitInsn(92);
        } else {
            this.visitInsn(89);
        }
        this.storeLocal(saveValueSlot);
        return saveValueSlot;
    }

    private int doInvokeBindingsSave() {
        Type type;
        int i;
        Type objectType = Type.getType(Object.class);
        Type objectArrayType = Type.getType("[Ljava/lang/Object;");
        Type[] invokeParamTypes = this.getInvokedTypes();
        int savedValueCount = invokeParamTypes.length;
        int arrayValueSlot = this.newLocal(objectArrayType);
        this.push(savedValueCount);
        this.newArray(objectType);
        this.storeLocal(arrayValueSlot);
        for (i = savedValueCount - 1; i >= 0; --i) {
            type = invokeParamTypes[i];
            if (type != null) {
                this.box(type);
                this.loadLocal(arrayValueSlot);
                this.swap(objectArrayType, objectType);
                this.push(i);
                this.swap(Type.INT_TYPE, objectType);
            } else {
                this.loadLocal(arrayValueSlot);
                this.push(i);
                this.push((Type)null);
            }
            this.arrayStore(objectType);
        }
        for (i = 0; i < savedValueCount; ++i) {
            type = invokeParamTypes[i];
            if (type == null) continue;
            this.loadLocal(arrayValueSlot);
            this.push(i);
            this.arrayLoad(objectType);
            this.unbox(type);
        }
        return arrayValueSlot;
    }

    private boolean doArgLoad(int saveSlot) {
        Binding binding;
        int i;
        if (this.callArrayBindings.size() == 0) {
            this.push((Type)null);
            return false;
        }
        int arraySize = this.callArrayBindings.size();
        this.push(arraySize);
        Type objectType = Type.getType(Object.class);
        this.newArray(objectType);
        boolean doUpdates = false;
        for (i = 0; i < arraySize; ++i) {
            binding = this.callArrayBindings.get(i);
            if (!binding.isUpdated()) continue;
            doUpdates = true;
            break;
        }
        if (doUpdates) {
            this.mv.visitInsn(91);
        }
        for (i = 0; i < arraySize; ++i) {
            binding = this.callArrayBindings.get(i);
            this.dup();
            this.push(i);
            if (binding.isParam()) {
                int idx = binding.getIndex() - 1;
                this.loadArg(idx);
                this.box(this.argumentTypes[idx]);
            } else if (binding.isLocalVar()) {
                int idx = binding.getLocalIndex();
                this.loadLocal(idx);
                if (binding.getDescriptor().equals("boolean")) {
                    this.box(Type.BOOLEAN_TYPE);
                } else {
                    this.box(this.getLocalType(idx));
                }
            } else if (binding.isParamCount()) {
                int count = this.argumentTypes.length;
                this.push(count);
                this.box(Type.INT_TYPE);
            } else if (binding.isParamArray()) {
                int count = this.argumentTypes.length;
                this.push(count + 1);
                this.newArray(objectType);
                this.dup();
                this.push(0);
                if ((this.access & 8) == 0) {
                    this.loadThis();
                } else {
                    this.push((Type)null);
                }
                this.arrayStore(objectType);
                for (int idx = 0; idx < count; ++idx) {
                    this.dup();
                    this.push(idx + 1);
                    this.loadArg(idx);
                    this.box(this.argumentTypes[idx]);
                    this.arrayStore(objectType);
                }
            } else if (binding.isInvokeParamArray()) {
                this.loadLocal(saveSlot);
            } else if (binding.isTriggerClass()) {
                String triggerClassName = TypeHelper.internalizeClass(this.getTriggerClassName());
                this.visitLdcInsn(triggerClassName);
            } else if (binding.isTriggerMethod()) {
                String triggerMethodName = this.name + TypeHelper.internalizeDescriptor(this.descriptor);
                this.visitLdcInsn(triggerMethodName);
            } else if (binding.isThrowable() | binding.isReturn()) {
                this.loadLocal(saveSlot);
                this.box(this.saveValueType);
            }
            this.arrayStore(objectType);
        }
        return doUpdates;
    }

    private void doArgUpdate() {
        Binding binding;
        int i;
        Type objectType = Type.getType(Object.class);
        int arraySize = this.callArrayBindings.size();
        int lastUpdated = -1;
        int returnIdx = -1;
        for (i = 0; i < arraySize; ++i) {
            binding = this.callArrayBindings.get(i);
            if (!binding.isUpdated()) continue;
            lastUpdated = i;
            if (!binding.isReturn()) continue;
            returnIdx = i;
        }
        if (returnIdx >= 0) {
            lastUpdated = returnIdx;
        }
        for (i = 0; i < arraySize; ++i) {
            int idx;
            binding = this.callArrayBindings.get(i);
            if (!binding.isUpdated() || binding.isReturn()) continue;
            if (i != lastUpdated) {
                this.dup();
            }
            this.push(i);
            this.arrayLoad(objectType);
            if (binding.isParam()) {
                idx = binding.getIndex() - 1;
                this.unbox(this.argumentTypes[idx]);
                this.storeArg(idx);
                continue;
            }
            if (!binding.isLocalVar()) continue;
            idx = binding.getLocalIndex();
            Type t = this.getLocalType(idx);
            if (t.getClassName().equals("java.lang.Object")) {
                String descriptor = binding.getDescriptor();
                t = Type.getType("L" + descriptor.replace('.', '/') + ";");
            } else if (t == Type.INT_TYPE && binding.getDescriptor().equals("boolean")) {
                t = Type.BOOLEAN_TYPE;
            }
            this.unbox(t);
            this.storeLocal(idx);
        }
        if (returnIdx >= 0) {
            if (this.saveValueType.getSize() == 2) {
                this.mv.visitInsn(91);
                this.mv.visitInsn(87);
                this.mv.visitInsn(88);
            } else {
                this.mv.visitInsn(95);
                this.mv.visitInsn(87);
            }
            this.push(returnIdx);
            this.arrayLoad(objectType);
            this.unbox(this.saveValueType);
        }
    }

    protected boolean inBytemanHandler() {
        return this.cfg.inBytemanHandler();
    }

    protected boolean inBytemanTrigger() {
        return this.cfg.inBytemanTrigger();
    }

    protected boolean inRethrowHandler() {
        return this.cfg.inRethrowHandler();
    }

    protected String getMethodName() {
        return this.name + TypeHelper.internalizeDescriptor(this.descriptor);
    }

    @Override
    public void visitCode() {
        super.visitCode();
        String methodName = this.getTriggerClassName() + "." + this.name + this.descriptor;
        Label newStart = super.newLabel();
        this.cfg = new CFG(methodName, newStart);
        this.visitLabel(newStart);
    }

    @Override
    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.cfg.add(opcode);
                Label newStart = super.newLabel();
                this.cfg.split(newStart);
                this.visitLabel(newStart);
                break;
            }
            case 194: 
            case 195: {
                this.cfg.add(opcode);
                break;
            }
            default: {
                this.cfg.add(opcode);
            }
        }
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.cfg.add(132, var, increment);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.cfg.add(opcode, operand);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.cfg.add(18, cst.toString());
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.cfg.add(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        super.visitTypeInsn(opcode, desc);
        this.cfg.add(opcode, desc);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        this.cfg.add(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.cfg.add(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        this.cfg.add(186, name, desc);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.cfg.add(opcode);
                Label newStart = super.newLabel();
                this.cfg.split(newStart, label, newStart);
                this.visitLabel(newStart);
                break;
            }
            case 167: {
                this.cfg.add(opcode);
                Label newStart = super.newLabel();
                this.cfg.split(newStart, label);
                this.visitLabel(newStart);
                break;
            }
            case 168: {
                this.cfg.add(opcode);
                Label newStart = super.newLabel();
                this.cfg.split(newStart, label, newStart);
                this.visitLabel(newStart);
                break;
            }
            case 198: 
            case 199: {
                this.cfg.add(opcode);
                Label newStart = super.newLabel();
                this.cfg.split(newStart, label, newStart);
                this.visitLabel(newStart);
            }
        }
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.cfg.visitLabel(label);
        if (this.cfg.tryCatchEnd(label)) {
            for (TryCatchDetails details : this.cfg.tryCatchEndDetails(label)) {
                super.visitTryCatchBlock(details.getStart(), details.getEnd(), details.getHandler(), details.getType());
            }
        }
    }

    public void visitTriggerStart(Label label) {
        this.cfg.visitTriggerStart(label);
        this.visitLabel(label);
    }

    public void visitTriggerEnd(Label label) {
        this.cfg.visitTriggerEnd(label);
        this.visitLabel(label);
        TriggerDetails details = this.cfg.triggerEndDetails(label);
        Label end = new Label();
        Label executeHandler = this.newLabel();
        if (!this.cfg.inOpenMonitor()) {
            Label returnHandler = this.newLabel();
            details.setEarlyReturnHandler(returnHandler);
            this.visitTryCatchBlock(details.getStart(), end, returnHandler, CFG.EARLY_RETURN_EXCEPTION_TYPE_NAME);
            Label throwHandler = this.newLabel();
            details.setThrowHandler(throwHandler);
            this.visitTryCatchBlock(details.getStart(), end, throwHandler, CFG.THROW_EXCEPTION_TYPE_NAME);
        }
        details.setExecuteHandler(executeHandler);
        this.visitTryCatchBlock(details.getStart(), end, executeHandler, CFG.EXECUTE_EXCEPTION_TYPE_NAME);
        this.visitLabel(end);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.cfg.add(170, min, max);
        Label newStart = super.newLabel();
        this.cfg.split(newStart, dflt, labels);
        this.visitLabel(newStart);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.cfg.add(170, keys);
        Label newStart = super.newLabel();
        this.cfg.split(newStart, dflt, labels);
        this.visitLabel(newStart);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        this.cfg.add(197, desc, dims);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.cfg.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        TriggerDetails details;
        Type returnType = Type.getReturnType(this.descriptor);
        Iterator<TriggerDetails> iterator = this.cfg.triggerDetails();
        boolean noneLeft = true;
        while (iterator.hasNext()) {
            details = iterator.next();
            Iterator<CodeLocation> openEnters = this.cfg.getOpenMonitors(details);
            if (!openEnters.hasNext()) continue;
            Label newStart = this.newLabel();
            Label newEnd = this.newLabel();
            if (details.getEarlyReturnHandler() != null || details.getThrowHandler() != null) {
                Helper.err("unexpected : trigger region with open monitorenters has subtype handler!");
            }
            newStart = this.newLabel();
            newEnd = this.newLabel();
            Label newEarlyReturn = this.newLabel();
            Label newThrow = this.newLabel();
            this.visitLabel(details.getExecuteHandler());
            Label newExecute = this.newLabel();
            this.visitLabel(newStart);
            while (openEnters.hasNext()) {
                CodeLocation enterLocation = openEnters.next();
                int varIdx = this.cfg.getSavedMonitorIdx(enterLocation);
                this.visitVarInsn(25, varIdx);
                this.visitInsn(195);
            }
            this.visitInsn(191);
            this.visitTryCatchBlock(newStart, newEnd, newEarlyReturn, CFG.EARLY_RETURN_EXCEPTION_TYPE_NAME);
            this.visitTryCatchBlock(newStart, newEnd, newThrow, CFG.THROW_EXCEPTION_TYPE_NAME);
            this.visitTryCatchBlock(newStart, newEnd, newExecute, CFG.EXECUTE_EXCEPTION_TYPE_NAME);
            this.visitLabel(newEnd);
            details.setThrowHandler(newThrow);
            details.setEarlyReturnHandler(newEarlyReturn);
            details.setExecuteHandler(newExecute);
        }
        iterator = this.cfg.triggerDetails();
        while (iterator.hasNext()) {
            details = iterator.next();
            this.visitLabel(details.getEarlyReturnHandler());
        }
        if (Transformer.isVerbose()) {
            this.getStatic(Type.getType(System.class), "out", Type.getType(PrintStream.class));
            this.visitLdcInsn("caught ReturnException");
            this.invokeVirtual(Type.getType(PrintStream.class), Method.getMethod("void println(String)"));
        }
        if (returnType == Type.VOID_TYPE) {
            this.pop();
            this.visitInsn(177);
        } else {
            Method getReturnValueMethod = Method.getMethod("Object getReturnValue()");
            this.invokeVirtual(CFG.EARLY_RETURN_EXCEPTION_TYPE, getReturnValueMethod);
            this.unbox(returnType);
            this.returnValue();
        }
        iterator = this.cfg.triggerDetails();
        while (iterator.hasNext()) {
            details = iterator.next();
            this.visitLabel(details.getThrowHandler());
        }
        if (Transformer.isVerbose()) {
            this.getStatic(Type.getType(System.class), "out", Type.getType(PrintStream.class));
            this.visitLdcInsn("caught ThrowException");
            this.invokeVirtual(Type.getType(PrintStream.class), Method.getMethod("void println(String)"));
        }
        Method getThrowableMethod = Method.getMethod("Throwable getThrowable()");
        this.invokeVirtual(CFG.THROW_EXCEPTION_TYPE, getThrowableMethod);
        this.throwException();
        iterator = this.cfg.triggerDetails();
        while (iterator.hasNext()) {
            TriggerDetails details2 = iterator.next();
            this.visitLabel(details2.getExecuteHandler());
        }
        if (Transformer.isVerbose()) {
            this.getStatic(Type.getType(System.class), "out", Type.getType(PrintStream.class));
            this.visitLdcInsn("caught ExecuteException");
            this.invokeVirtual(Type.getType(PrintStream.class), Method.getMethod("void println(String)"));
        }
        this.throwException();
        super.visitMaxs(maxStack, maxLocals);
        this.cfg.visitMaxs();
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.cfg.visitEnd();
    }

    protected void injectTriggerPoint() {
        this.rule.setTypeInfo(this.getTriggerClassName(), this.access, this.name, this.descriptor, this.exceptions);
        String key = this.rule.getKey();
        Type ruleType = Type.getType(TypeHelper.externalizeType("org.jboss.byteman.rule.Rule"));
        Method method = Method.getMethod("void execute(String, Object, Object[])");
        Helper.verbose("RuleTriggerMethodAdapter.injectTriggerPoint : inserting trigger into " + this.getTriggerClassName() + "." + this.getMethodName() + " for rule " + this.rule.getName());
        Label startLabel = this.newLabel();
        Label endLabel = this.newLabel();
        this.visitTriggerStart(startLabel);
        this.setBindingIndices();
        int saveValueSlot = this.bindReturnOrThrowableValue ? this.doReturnOrThrowSave() : (this.bindInvokeParams ? this.doInvokeBindingsSave() : -1);
        this.push(key);
        if ((this.access & 8) == 0) {
            this.loadThis();
        } else {
            this.push((Type)null);
        }
        boolean handleUpdates = this.doArgLoad(saveValueSlot);
        if (saveValueSlot >= 0) {
            this.popLocal(saveValueSlot);
        }
        this.invokeStatic(ruleType, method);
        if (handleUpdates) {
            this.doArgUpdate();
        }
        this.visitTriggerEnd(endLabel);
    }
}

