/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.client;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.extension.byteman.impl.common.GenerateScriptUtil;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class AgentInstaller {
    @Inject
    private Instance<ArquillianDescriptor> descriptorInst;

    public void install(@Observes(precedence=1) BeforeSuite event) {
        try {
            BytemanConfiguration config = BytemanConfiguration.from((ArquillianDescriptor)this.descriptorInst.get());
            if (!config.autoInstallAgent()) {
                return;
            }
            try {
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.arquillian.extension.byteman.agent.Main");
                if (!((Boolean)mainClass.getDeclaredField("firstTime").get(null)).booleanValue()) {
                    return;
                }
            }
            catch (ClassNotFoundException mainClass) {
                // empty catch block
            }
            String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            File bytemanHome = File.createTempFile("byteman", "agent");
            bytemanHome.delete();
            bytemanHome.mkdir();
            File bytemanLib = new File(bytemanHome, "lib");
            bytemanLib.mkdirs();
            InputStream bytemanInputJar = ((ZipExporter)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new String[]{"org.jboss.byteman"})).setManifest((Asset)new StringAsset("Manifest-Version: 1.0\nCreated-By: Arquillian\nImplementation-Version: 0.0.0.Arq\nPremain-Class: org.jboss.byteman.agent.Main\nAgent-Class: org.jboss.byteman.agent.Main\nCan-Redefine-Classes: true\nCan-Retransform-Classes: true\n"))).as(ZipExporter.class)).exportAsInputStream();
            File bytemanJar = new File(bytemanLib, BytemanConfiguration.BYTEMAN_JAR);
            GenerateScriptUtil.copy(bytemanInputJar, new FileOutputStream(bytemanJar));
            VirtualMachine vm = VirtualMachine.attach(pid);
            String agentProperties = config.agentProperties();
            vm.loadAgent(bytemanJar.getAbsolutePath(), "listener:true,port:" + config.clientAgentPort() + (agentProperties != null ? ",prop:" + agentProperties : ""));
            vm.detach();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write byteman.jar to disk", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not install byteman agent", e);
        }
    }
}

