/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.event.Event;
import org.jboss.arquillian.extension.byteman.impl.common.ExecContext;
import org.jboss.arquillian.extension.byteman.impl.common.ExtractScriptUtil;
import org.jboss.arquillian.extension.byteman.impl.common.SubmitUtil;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.ClassLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

public abstract class AbstractRuleInstaller {
    private static final Logger log = Logger.getLogger(AbstractRuleInstaller.class.getName());
    public static final String CLASS_KEY_PREFIX = "Class:";
    public static final String METHOD_KEY_PREFIX = "Method:";

    protected abstract List<ExecContext> getExecContexts(Event var1);

    private static void install(String prefix, String script, ExecContext context) {
        if (script != null) {
            try {
                SubmitUtil.install(AbstractRuleInstaller.generateKey(prefix), script, context);
            }
            catch (RuntimeException e) {
                log.severe(String.format("Error installing '%s' script to %s:%s, exec %s, msg: %s", prefix, context.getAddress(), context.getPort(), context.getExec(), e.getMessage()));
                throw e;
            }
        }
    }

    private static void uninstall(String prefix, String script, ExecContext context) {
        if (script != null) {
            try {
                SubmitUtil.uninstall(AbstractRuleInstaller.generateKey(prefix), script, context);
            }
            catch (RuntimeException e) {
                log.severe(String.format("Error uninstalling '%s' script to  %s:%s, exec %s, msg: %s", prefix, context.getAddress(), context.getPort(), context.getExec(), e.getMessage()));
                throw e;
            }
        }
    }

    public void installClass(@Observes BeforeClass event) {
        for (ExecContext context : this.getExecContexts((Event)event)) {
            String script = ExtractScriptUtil.extract(context, (ClassLifecycleEvent)event);
            AbstractRuleInstaller.install(CLASS_KEY_PREFIX, script, context);
        }
    }

    public void uninstallClass(@Observes AfterClass event) {
        for (ExecContext context : this.getExecContexts((Event)event)) {
            String script = ExtractScriptUtil.extract(context, (ClassLifecycleEvent)event);
            AbstractRuleInstaller.uninstall(AbstractRuleInstaller.generateKey(CLASS_KEY_PREFIX), script, context);
        }
    }

    protected abstract boolean shouldRun(TestEvent var1);

    public void installMethod(@Observes Before event) {
        if (!this.shouldRun((TestEvent)event)) {
            return;
        }
        for (ExecContext context : this.getExecContexts((Event)event)) {
            String script = ExtractScriptUtil.extract(context, (TestLifecycleEvent)event);
            AbstractRuleInstaller.install(METHOD_KEY_PREFIX, script, context);
        }
    }

    public void uninstallMethod(@Observes After event) {
        if (!this.shouldRun((TestEvent)event)) {
            return;
        }
        for (ExecContext context : this.getExecContexts((Event)event)) {
            String script = ExtractScriptUtil.extract(context, (TestLifecycleEvent)event);
            AbstractRuleInstaller.uninstall(METHOD_KEY_PREFIX, script, context);
        }
    }

    private static String generateKey(String prefix) {
        return prefix + Thread.currentThread().getName();
    }
}

