/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.spi.event.Event;
import org.jboss.arquillian.extension.byteman.api.ExecType;
import org.jboss.arquillian.extension.byteman.impl.client.AddressProvider;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.test.spi.event.suite.ClassLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

public class ExecContext {
    private static final Logger log = Logger.getLogger(ExecContext.class.getName());
    private final String address;
    private final int port;
    private final EnumSet<ExecType> exec;
    private final BytemanConfiguration configuration;
    private final Set<ExecType> matched = new HashSet<ExecType>();

    public ExecContext(int port, EnumSet<ExecType> exec, BytemanConfiguration configuration) {
        this("localhost", port, exec, configuration);
    }

    public ExecContext(String address, int port, EnumSet<ExecType> exec, BytemanConfiguration configuration) {
        this.address = address;
        this.port = port;
        this.exec = exec;
        this.configuration = configuration;
    }

    public boolean match(ExecType execType) {
        if (this.getExec().contains((Object)execType)) {
            this.matched.add(execType);
            return true;
        }
        return false;
    }

    public void validate(ClassLifecycleEvent event) {
        if (this.matched.contains((Object)ExecType.CLIENT_CONTAINER) && AddressProvider.provideAddress((Event)event) == null) {
            log.warning(String.format("Can only handle %s container agent address; no %s available.", "localhost", ProtocolMetaData.class.getSimpleName()));
        }
    }

    public void validate(TestLifecycleEvent event) {
    }

    public void validate(ExecType execType) {
        if (execType == ExecType.CLIENT_CONTAINER && this.configuration != null && this.configuration.autoInstallAgent()) {
            log.warning(String.format("Using %s with autoInstallAgent -- is container agent running?", new Object[]{execType}));
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public EnumSet<ExecType> getExec() {
        return this.exec;
    }

    public BytemanConfiguration getConfiguration() {
        return this.configuration;
    }
}

