/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.deployment;

import com.github.fungal.api.deployment.Bean;
import com.github.fungal.api.deployment.Constructor;
import com.github.fungal.api.deployment.Create;
import com.github.fungal.api.deployment.Depends;
import com.github.fungal.api.deployment.Destroy;
import com.github.fungal.api.deployment.Entry;
import com.github.fungal.api.deployment.Factory;
import com.github.fungal.api.deployment.Incallback;
import com.github.fungal.api.deployment.Inject;
import com.github.fungal.api.deployment.Install;
import com.github.fungal.api.deployment.Key;
import com.github.fungal.api.deployment.List;
import com.github.fungal.api.deployment.Map;
import com.github.fungal.api.deployment.Null;
import com.github.fungal.api.deployment.Parameter;
import com.github.fungal.api.deployment.Property;
import com.github.fungal.api.deployment.Set;
import com.github.fungal.api.deployment.Start;
import com.github.fungal.api.deployment.Stop;
import com.github.fungal.api.deployment.This;
import com.github.fungal.api.deployment.Uncallback;
import com.github.fungal.api.deployment.Uninstall;
import com.github.fungal.api.deployment.Value;
import com.github.fungal.deployment.Deployment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Unmarshaller {
    private Logger log = Logger.getLogger(Unmarshaller.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINEST);

    public Deployment unmarshal(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("File is null");
        }
        InputStream is = null;
        try {
            Deployment deployment = new Deployment();
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.toURI());
                is = new FileInputStream(file);
            } else if ("jar".equals(url.getProtocol())) {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                is = jarConnection.getInputStream();
            } else {
                throw new IOException("Unsupport protocol: " + url);
            }
            is = new BufferedInputStream(is, 4096);
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
            boolean found = false;
            while (xmlStreamReader.hasNext()) {
                int eventCode = xmlStreamReader.next();
                switch (eventCode) {
                    case 1: {
                        if ("deployment".equals(xmlStreamReader.getLocalName())) {
                            found = true;
                            break;
                        }
                        if (!found || !"bean".equals(xmlStreamReader.getLocalName())) break;
                        deployment.getBean().add(this.readBean(xmlStreamReader));
                        break;
                    }
                }
            }
            Deployment deployment2 = deployment;
            return deployment2;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private Bean readBean(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String beanName = null;
        String beanClazz = null;
        String beanInterface = null;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("name".equals(name)) {
                beanName = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if ("class".equals(name)) {
                beanClazz = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (!"interface".equals(name)) continue;
            beanInterface = xmlStreamReader.getAttributeValue(i);
        }
        if (beanName == null || beanName.trim().equals("")) {
            throw new XMLStreamException("bean name not defined", xmlStreamReader.getLocation());
        }
        Bean result = new Bean(beanName);
        result.setClazz(beanClazz);
        result.setInterface(beanInterface);
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if ("constructor".equals(name)) {
                        result.setConstructor(this.readConstructor(xmlStreamReader));
                        break;
                    }
                    if ("property".equals(name)) {
                        result.getProperty().add(this.readProperty(xmlStreamReader));
                        break;
                    }
                    if ("depends".equals(name)) {
                        result.getDepends().add(this.readDepends(xmlStreamReader));
                        break;
                    }
                    if ("install".equals(name)) {
                        result.getInstall().add(this.readInstall(xmlStreamReader));
                        break;
                    }
                    if ("uninstall".equals(name)) {
                        result.getUninstall().add(this.readUninstall(xmlStreamReader));
                        break;
                    }
                    if ("incallback".equals(name)) {
                        result.getIncallback().add(this.readIncallback(xmlStreamReader));
                        break;
                    }
                    if ("uncallback".equals(name)) {
                        result.getUncallback().add(this.readUncallback(xmlStreamReader));
                        break;
                    }
                    if ("create".equals(name)) {
                        result.setCreate(this.readCreate(xmlStreamReader));
                        break;
                    }
                    if ("start".equals(name)) {
                        result.setStart(this.readStart(xmlStreamReader));
                        break;
                    }
                    if ("stop".equals(name)) {
                        result.setStop(this.readStop(xmlStreamReader));
                        break;
                    }
                    if ("destroy".equals(name)) {
                        result.setDestroy(this.readDestroy(xmlStreamReader));
                        break;
                    }
                    if ("ignoreCreate".equals(name)) {
                        result.setIgnoreCreate(this.readIgnoreCreate(xmlStreamReader));
                        break;
                    }
                    if ("ignoreStart".equals(name)) {
                        result.setIgnoreStart(this.readIgnoreStart(xmlStreamReader));
                        break;
                    }
                    if ("ignoreStop".equals(name)) {
                        result.setIgnoreStop(this.readIgnoreStop(xmlStreamReader));
                        break;
                    }
                    if (!"ignoreDestroy".equals(name)) break;
                    result.setIgnoreDestroy(this.readIgnoreDestroy(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"bean".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("bean tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Constructor readConstructor(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String name;
        Constructor result = new Constructor();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            name = xmlStreamReader.getAttributeLocalName(i);
            if ("factoryMethod".equals(name)) {
                result.setFactoryMethod(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if (!"factoryClass".equals(name)) continue;
            result.setFactoryClass(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    name = xmlStreamReader.getLocalName();
                    if ("parameter".equals(name)) {
                        result.getParameter().add(this.readParameter(xmlStreamReader));
                        break;
                    }
                    if (!"factory".equals(name)) break;
                    result.setFactory(this.readFactory(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"constructor".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("constructor tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Parameter readParameter(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String name;
        Parameter result = new Parameter();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            name = xmlStreamReader.getAttributeLocalName(i);
            if (!"class".equals(name)) continue;
            result.setClazz(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    name = xmlStreamReader.getLocalName();
                    if ("inject".equals(name)) {
                        result.getContent().add(this.readInject(xmlStreamReader));
                        break;
                    }
                    if (!"null".equals(name)) break;
                    result.getContent().add(this.readNull(xmlStreamReader));
                    break;
                }
                case 4: {
                    if (xmlStreamReader.getText().trim().equals("")) break;
                    result.getContent().add(xmlStreamReader.getText());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"parameter".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("parameter tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Property readProperty(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String propertyName = null;
        String clazz = null;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("name".equals(name)) {
                propertyName = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (!"class".equals(name)) continue;
            clazz = xmlStreamReader.getAttributeValue(i);
        }
        if (propertyName == null || propertyName.trim().equals("")) {
            throw new XMLStreamException("Name is mandatory", xmlStreamReader.getLocation());
        }
        Property result = new Property(propertyName);
        result.setClazz(clazz);
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if ("inject".equals(name)) {
                        result.getContent().add(this.readInject(xmlStreamReader));
                        break;
                    }
                    if ("set".equals(name)) {
                        result.getContent().add(this.readSet(xmlStreamReader));
                        break;
                    }
                    if ("map".equals(name)) {
                        result.getContent().add(this.readMap(xmlStreamReader));
                        break;
                    }
                    if ("list".equals(name)) {
                        result.getContent().add(this.readList(xmlStreamReader));
                        break;
                    }
                    if ("null".equals(name)) {
                        result.getContent().add(this.readNull(xmlStreamReader));
                        break;
                    }
                    if (!"this".equals(name)) break;
                    result.getContent().add(this.readThis(xmlStreamReader));
                    break;
                }
                case 4: {
                    if (xmlStreamReader.getText().trim().equals("")) break;
                    result.getContent().add(xmlStreamReader.getText());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"property".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("property tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Inject readInject(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String bean = null;
        String property = null;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("bean".equals(name)) {
                bean = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (!"property".equals(name)) continue;
            property = xmlStreamReader.getAttributeValue(i);
        }
        if (bean == null || bean.trim().equals("")) {
            throw new XMLStreamException("Bean is mandatory", xmlStreamReader.getLocation());
        }
        Inject result = new Inject(bean);
        result.setProperty(property);
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    result.setValue(xmlStreamReader.getText());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"inject".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("inject tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Depends readDepends(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Depends result = new Depends();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    result.setValue(xmlStreamReader.getText());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"depends".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("depends tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Install readInstall(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Install result = new Install();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"install".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("install tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Uninstall readUninstall(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Uninstall result = new Uninstall();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"uninstall".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("uninstall tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Incallback readIncallback(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Incallback result = new Incallback();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"incallback".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("incallback tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Uncallback readUncallback(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Uncallback result = new Uncallback();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"uncallback".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("uncallback tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Map readMap(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String keyClass = null;
        String valueClass = null;
        String clazz = null;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("keyClass".equals(name)) {
                keyClass = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if ("valueClass".equals(name)) {
                valueClass = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (!"class".equals(name)) continue;
            clazz = xmlStreamReader.getAttributeValue(i);
        }
        if (keyClass == null || keyClass.trim().equals("")) {
            throw new XMLStreamException("Key class is mandatory", xmlStreamReader.getLocation());
        }
        if (valueClass == null || valueClass.trim().equals("")) {
            throw new XMLStreamException("Value class is mandatory", xmlStreamReader.getLocation());
        }
        Map result = new Map(keyClass, valueClass);
        result.setClazz(clazz);
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if (!"entry".equals(name)) break;
                    result.getEntry().add(this.readEntry(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"map".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("map tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Set readSet(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String elementClass = null;
        String clazz = null;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("elementClass".equals(name)) {
                elementClass = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (!"class".equals(name)) continue;
            clazz = xmlStreamReader.getAttributeValue(i);
        }
        if (elementClass == null || elementClass.trim().equals("")) {
            throw new XMLStreamException("Element class is mandatory", xmlStreamReader.getLocation());
        }
        Set result = new Set(elementClass);
        result.setClazz(clazz);
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if (!"value".equals(name)) break;
                    result.getValue().add(this.readValue(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"set".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("set tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private List readList(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String elementClass = null;
        String clazz = null;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("elementClass".equals(name)) {
                elementClass = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (!"class".equals(name)) continue;
            clazz = xmlStreamReader.getAttributeValue(i);
        }
        if (elementClass == null || elementClass.trim().equals("")) {
            throw new XMLStreamException("Element class is mandatory", xmlStreamReader.getLocation());
        }
        List result = new List(elementClass);
        result.setClazz(clazz);
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if (!"value".equals(name)) break;
                    result.getValue().add(this.readValue(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"list".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("list tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Entry readEntry(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Entry result = new Entry();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if ("key".equals(name)) {
                        result.setKey(this.readKey(xmlStreamReader));
                        break;
                    }
                    if (!"value".equals(name)) break;
                    result.setValue(this.readValue(xmlStreamReader));
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"entry".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("entry tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Key readKey(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Key result = new Key();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    result.setValue(xmlStreamReader.getText());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"key".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("key tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Value readValue(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Value result = new Value();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    result.setValue(xmlStreamReader.getText());
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"value".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("value tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Null readNull(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Null result = new Null();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"null".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("null tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private This readThis(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        This result = new This();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"this".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("this tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Factory readFactory(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Factory result = new Factory();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"bean".equals(name)) continue;
            result.setBean(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"factory".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("factory tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Create readCreate(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Create result = new Create();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"create".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("create tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Start readStart(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Start result = new Start();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"start".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("start tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Stop readStop(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Stop result = new Stop();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"stop".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("stop tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private Destroy readDestroy(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Destroy result = new Destroy();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"method".equals(name)) continue;
            result.setMethod(xmlStreamReader.getAttributeValue(i));
        }
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"destroy".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("destroy tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private boolean readIgnoreCreate(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"ignoreCreate".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("ignoreCreate tag not completed", xmlStreamReader.getLocation());
        }
        return true;
    }

    private boolean readIgnoreStart(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"ignoreStart".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("ignoreStart tag not completed", xmlStreamReader.getLocation());
        }
        return true;
    }

    private boolean readIgnoreStop(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"ignoreStop".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("ignoreStop tag not completed", xmlStreamReader.getLocation());
        }
        return true;
    }

    private boolean readIgnoreDestroy(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
        if (!"ignoreDestroy".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("ignoreDestroy tag not completed", xmlStreamReader.getLocation());
        }
        return true;
    }
}

