/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.classloader;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.impl.classloader.ChildrenClassLoader;
import com.github.fungal.impl.classloader.SecurityActions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class ParentLastClassLoader
extends KernelClassLoader {
    private ChildrenClassLoader children;

    public ParentLastClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        this.children = SecurityActions.createChildrenClassLoader(urls, ClassLoader.getSystemClassLoader(), this);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result = super.loadClass(name);
        if (result != null) {
            return result;
        }
        try {
            return this.children.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return this.loadClass(name, false);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.children.findClass(name);
        }
        catch (Throwable throwable) {
            return super.findClass(name);
        }
    }

    Class<?> lookup(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.children.getResource(name);
        if (resource != null) {
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = this.children.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> v = new Vector<URL>();
        Enumeration<URL> e = this.children.getResources(name);
        if (e != null) {
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
        }
        if ((e = super.getResources(name)) != null) {
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
        }
        return v.elements();
    }

    @Override
    public void clearAssertionStatus() {
        super.clearAssertionStatus();
        this.children.clearAssertionStatus();
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.children.setClassAssertionStatus(className, enabled);
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.children.setDefaultAssertionStatus(enabled);
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.children.setPackageAssertionStatus(packageName, enabled);
        super.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> result = null;
        URL[] urls = this.children.getURLs();
        if (urls != null) {
            result = new ArrayList<URL>(urls.length);
            for (URL u : urls) {
                result.add(u);
            }
        }
        if ((urls = super.getURLs()) != null) {
            if (result == null) {
                result = new ArrayList(urls.length);
            }
            for (URL u : urls) {
                result.add(u);
            }
        }
        if (result == null) {
            return new URL[0];
        }
        return result.toArray(new URL[result.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentLastClassLoader@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[parent=").append(this.getParent());
        sb.append(" urls=").append(Arrays.toString(this.getURLs()));
        sb.append("]");
        return sb.toString();
    }
}

