/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.sjc.maven;

import java.io.File;
import java.io.Serializable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.jca.sjc.maven.AbstractHostPortMojo;

public class Undeploy
extends AbstractHostPortMojo {
    private File file = null;

    public void setFile(File v) {
        this.file = v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.file == null) {
            throw new MojoFailureException("File not defined");
        }
        if (!this.file.exists()) {
            throw new MojoFailureException("File doesn't exists: " + this.file);
        }
        try {
            Boolean result = null;
            if (this.isLocal()) {
                Serializable value = this.executeCommand("local-undeploy", new Serializable[]{this.file.toURI().toURL()});
                if (!(value instanceof Boolean)) throw (Throwable)value;
                result = (Boolean)value;
            } else {
                Serializable value = this.executeCommand("remote-undeploy", new Serializable[]{this.file.getName()});
                if (!(value instanceof Boolean)) throw (Throwable)value;
                result = (Boolean)value;
            }
            if (result.booleanValue()) {
                this.getLog().info((CharSequence)("Undeployed: " + this.file.getName()));
                return;
            } else {
                this.getLog().info((CharSequence)(this.file.getName() + " wasn't undeployed"));
            }
            return;
        }
        catch (Throwable t) {
            throw new MojoFailureException("Unable to undeploy to " + this.getHost() + ":" + this.getPort() + " (" + t.getMessage() + ")", t);
        }
    }
}

