/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.jca.validator.Validation;

public class Main {
    private static final int SUCCESS = 0;
    private static final int FAIL = 1;
    private static final int OTHER = 2;

    public static void main(String[] args) {
        boolean quiet = false;
        String outputDir = ".";
        int arg = 0;
        String[] classpath = null;
        if (args.length > 0) {
            while (args.length > arg + 1) {
                if (args[arg].startsWith("-")) {
                    if (args[arg].endsWith("quiet")) {
                        quiet = true;
                    } else if (args[arg].endsWith("output")) {
                        if (++arg + 1 >= args.length) {
                            Main.usage();
                            System.exit(2);
                        }
                        outputDir = args[arg];
                    } else if (args[arg].endsWith("classpath")) {
                        classpath = args[++arg].split(System.getProperty("path.separator"));
                    }
                } else {
                    Main.usage();
                    System.exit(2);
                }
                ++arg;
            }
            try {
                int systemExitCode = Validation.validate((URL)new File(args[arg]).toURI().toURL(), (String)outputDir, classpath);
                if (!quiet) {
                    if (systemExitCode == 0) {
                        System.out.println("Validation sucessful");
                    } else if (systemExitCode == 1) {
                        System.out.println("Validation errors");
                    } else if (systemExitCode == 2) {
                        System.out.println("Validation unknown");
                    }
                }
                System.exit(systemExitCode);
            }
            catch (ArrayIndexOutOfBoundsException oe) {
                Main.usage();
                System.exit(2);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            Main.usage();
        }
        System.exit(0);
    }

    private static void usage() {
        System.out.println("Usage: validator [-quiet] [-output directory] [-classpath thirdparty.jar] <file>");
    }
}

