/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.Icon;
import org.jboss.jca.common.api.metadata.spec.IdDecoratedMetadata;
import org.jboss.jca.common.api.metadata.spec.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.LicenseType;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.SecurityPermission;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.spec.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.spec.ConnectorImpl;
import org.jboss.jca.common.metadata.spec.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.ResourceAdapterImpl;

public class Merger {
    public static final String ENCODED_SEMICOLON = "#semicolon#";

    public List<ConfigProperty> mergeConfigProperties(Map<String, String> ijProperties, List<ConfigProperty> original) {
        ArrayList<ConfigProperty> mergedProperties = new ArrayList<ConfigProperty>(original.size());
        for (ConfigProperty c : original) {
            if (ijProperties != null && ijProperties.containsKey(c.getConfigPropertyName().getValue())) {
                XsdString newValue = new XsdString(ijProperties.get(c.getConfigPropertyName().getValue()), c.getConfigPropertyValue().getId(), c.getConfigPropertyValue().getTag());
                ConfigPropertyImpl newProp = new ConfigPropertyImpl(c.getDescriptions(), c.getConfigPropertyName(), c.getConfigPropertyType(), newValue, c.getConfigPropertyIgnore(), c.getConfigPropertySupportsDynamicUpdates(), c.getConfigPropertyConfidential(), c.getId(), c.isMandatory(), c.getAttachedClassName(), c.getConfigPropertyIgnoreId(), c.getConfigPropertySupportsDynamicUpdatesId(), c.getConfigPropertyConfidentialId());
                mergedProperties.add(newProp);
                continue;
            }
            mergedProperties.add(c);
        }
        return mergedProperties;
    }

    public Connector mergeConnectorWithCommonIronJacamar(Activation ij, Connector conn) {
        if (ij == null) {
            return conn;
        }
        this.mergeTransactionSupport(ij, conn);
        List<ConfigProperty> original = conn.getResourceadapter().getConfigProperties();
        List<ConfigProperty> newProperties = this.mergeConfigProperties(ij.getConfigProperties(), original);
        ((ResourceAdapterImpl)conn.getResourceadapter()).forceConfigProperties(newProperties);
        if (conn.getVersion() != Connector.Version.V_10) {
            Iterator<IdDecoratedMetadata> iterator;
            ResourceAdapter ra = conn.getResourceadapter();
            if (ra != null && ra.getAdminObjects() != null) {
                ArrayList<AdminObject> newAdminObjects = new ArrayList<AdminObject>(ra.getAdminObjects().size());
                iterator = ra.getAdminObjects().iterator();
                while (iterator.hasNext()) {
                    AdminObject adminObj;
                    AdminObject newAdminObj = adminObj = iterator.next();
                    newAdminObjects.add(newAdminObj);
                }
                ((ResourceAdapterImpl)ra).forceAdminObjects(newAdminObjects);
            }
            if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null) {
                ArrayList<ConnectionDefinition> newConDefs = new ArrayList<ConnectionDefinition>(ra.getOutboundResourceadapter().getConnectionDefinitions().size());
                iterator = ra.getOutboundResourceadapter().getConnectionDefinitions().iterator();
                while (iterator.hasNext()) {
                    ConnectionDefinition conDef;
                    ConnectionDefinition newConDef = conDef = (ConnectionDefinition)iterator.next();
                    newConDefs.add(newConDef);
                }
                ((OutboundResourceAdapterImpl)ra.getOutboundResourceadapter()).forceConnectionDefinitions(newConDefs);
            }
        }
        return conn;
    }

    private void mergeTransactionSupport(Activation ij, Connector conn) {
        ResourceAdapter ra;
        if (ij.getTransactionSupport() != null && conn.getResourceadapter() != null && (ra = conn.getResourceadapter()).getOutboundResourceadapter() != null) {
            ((OutboundResourceAdapterImpl)ra.getOutboundResourceadapter()).forceTransactionSupport(ij.getTransactionSupport());
        }
    }

    public Connector mergeConnectorAndDs(CommonDataSource cds, Connector connector) throws IllegalArgumentException, Exception {
        if (cds == null) {
            return null;
        }
        return this.mergeConnectorWithProperties(connector, Merger.createConfigProperties(cds, this.extractProperties(connector)), null);
    }

    private Connector mergeConnectorWithProperties(Connector connector, List<ConfigProperty> connectioDefProperties, List<ConfigProperty> raConfigProperties) throws IllegalArgumentException, Exception {
        XsdString managedconnectionfactoryClass = null;
        String id = null;
        XsdString connectionfactoryImplClass = null;
        XsdString connectionfactoryInterface = null;
        XsdString connectionImplClass = null;
        XsdString connectionInterface = null;
        List<AuthenticationMechanism> authenticationMechanism = null;
        boolean reauthenticationSupport = false;
        List<SecurityPermission> securityPermissions = null;
        XsdString vendorName = null;
        List<LocalizedXsdString> description = null;
        XsdString resourceadapterVersion = null;
        XsdString moduleName = null;
        XsdString eisType = null;
        LicenseType license = null;
        List<LocalizedXsdString> displayNames = null;
        List<Icon> icons = null;
        List<AdminObject> adminobjects = null;
        TransactionSupportEnum transactionSupport = null;
        if (connector.getVersion() == Connector.Version.V_10) {
            if (raConfigProperties != null) {
                if (connectioDefProperties == null) {
                    connectioDefProperties = raConfigProperties;
                } else {
                    connectioDefProperties.addAll(raConfigProperties);
                }
            }
            ArrayList<ConnectionDefinition> cds = new ArrayList<ConnectionDefinition>(1);
            ConnectionDefinitionImpl cd = new ConnectionDefinitionImpl(managedconnectionfactoryClass, connectioDefProperties, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, id);
            cds.add(cd);
            OutboundResourceAdapterImpl ora = new OutboundResourceAdapterImpl(cds, transactionSupport, authenticationMechanism, reauthenticationSupport, id, null, null);
            ResourceAdapterImpl resourceadapter = new ResourceAdapterImpl(null, null, ora, null, null, securityPermissions, id);
            ConnectorImpl newConnector = new ConnectorImpl(Connector.Version.V_10, null, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, true, description, displayNames, icons, id);
            return (Connector)newConnector.merge(connector);
        }
        ArrayList<ConnectionDefinition> connectionDefinitions = new ArrayList<ConnectionDefinition>(1);
        ConnectionDefinitionImpl connectionDefinition = new ConnectionDefinitionImpl(managedconnectionfactoryClass, connectioDefProperties, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, id);
        connectionDefinitions.add(connectionDefinition);
        OutboundResourceAdapterImpl outboundResourceadapter = new OutboundResourceAdapterImpl(connectionDefinitions, transactionSupport, authenticationMechanism, reauthenticationSupport, id, null, null);
        String resourceadapterClass = null;
        InboundResourceAdapter inboundResourceadapter = null;
        ResourceAdapterImpl resourceadapter = new ResourceAdapterImpl(new XsdString(resourceadapterClass, null), raConfigProperties, outboundResourceadapter, inboundResourceadapter, adminobjects, securityPermissions, id);
        if (connector.getVersion() == Connector.Version.V_21) {
            ConnectorImpl newConnector = new ConnectorImpl(Connector.Version.V_21, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, false, description, displayNames, icons, id);
            return (Connector)newConnector.merge(connector);
        }
        if (connector.getVersion() == Connector.Version.V_20) {
            ConnectorImpl newConnector = new ConnectorImpl(Connector.Version.V_20, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, false, description, displayNames, icons, id);
            return (Connector)newConnector.merge(connector);
        }
        if (connector.getVersion() == Connector.Version.V_17) {
            ConnectorImpl newConnector = new ConnectorImpl(Connector.Version.V_17, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, false, description, displayNames, icons, id);
            return (Connector)newConnector.merge(connector);
        }
        if (connector.getVersion() == Connector.Version.V_16) {
            ConnectorImpl newConnector = new ConnectorImpl(Connector.Version.V_16, moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, false, description, displayNames, icons, id);
            return (Connector)newConnector.merge(connector);
        }
        if (connector.getVersion() == Connector.Version.V_15) {
            ConnectorImpl newConnector = new ConnectorImpl(Connector.Version.V_15, null, vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, true, description, displayNames, icons, id);
            return (Connector)newConnector.merge(connector);
        }
        throw new IllegalArgumentException("version= " + connector.getVersion().name());
    }

    private List<ConfigProperty> extractProperties(Connector connector) {
        ResourceAdapter ra;
        List<ConfigProperty> originalProperties = null;
        if (connector.getVersion() == Connector.Version.V_10) {
            originalProperties = connector.getResourceadapter().getConfigProperties();
        } else if (connector.getResourceadapter() != null && (ra = connector.getResourceadapter()).getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null) {
            originalProperties = ra.getOutboundResourceadapter().getConnectionDefinitions().get(0).getConfigProperties();
        }
        return originalProperties;
    }

    private static List<ConfigProperty> createConfigProperties(CommonDataSource cds, List<ConfigProperty> originalProperties) {
        DataSource ds = null;
        XaDataSource xads = null;
        if (cds instanceof DataSource) {
            ds = (DataSource)cds;
        }
        if (cds instanceof XaDataSource) {
            xads = (XaDataSource)cds;
        }
        if (originalProperties != null) {
            ConfigPropertyFactory.Prototype prototype;
            ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>(originalProperties.size());
            block28: for (ConfigProperty configProperty : originalProperties) {
                prototype = ConfigPropertyFactory.Prototype.forName(configProperty.getConfigPropertyName().getValue());
                switch (prototype.ordinal()) {
                    case 5: {
                        if (ds == null) break;
                        DsSecurity security = ds.getSecurity();
                        if (security == null || security.getUserName() == null || security.getUserName().trim().equals("")) continue block28;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, security.getUserName()));
                        break;
                    }
                    case 6: {
                        if (ds == null) break;
                        DsSecurity security = ds.getSecurity();
                        if (security == null || security.getPassword() == null || security.getPassword().trim().equals("")) continue block28;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, security.getPassword()));
                        break;
                    }
                    case 7: {
                        if (xads == null || xads.getXaDataSourceProperty() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry<String, String> xaConfigProperty : xads.getXaDataSourceProperty().entrySet()) {
                            valueBuf.append(xaConfigProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append(Merger.encodeConfigProperty(xaConfigProperty.getValue()));
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case 8: {
                        if (ds == null || ds.getUrlDelimiter() == null || ds.getUrlDelimiter().trim().equals("")) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getUrlDelimiter()));
                        break;
                    }
                    case 10: {
                        if (ds == null || ds.getUrlSelectorStrategyClassName() == null || ds.getUrlSelectorStrategyClassName().trim().equals("")) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getUrlSelectorStrategyClassName()));
                        break;
                    }
                    case 11: {
                        if (xads == null || xads.getXaDataSourceClass() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, xads.getXaDataSourceClass()));
                        break;
                    }
                    case 12: {
                        if (ds == null || ds.getTransactionIsolation() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTransactionIsolation().name()));
                        break;
                    }
                    case 13: {
                        if (ds == null || ds.getStatement() == null || ds.getStatement().getPreparedStatementsCacheSize() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getStatement().getPreparedStatementsCacheSize()));
                        break;
                    }
                    case 14: {
                        if (ds == null || ds.getStatement() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getStatement() != null && ds.getStatement().isSharePreparedStatements() != false));
                        break;
                    }
                    case 15: {
                        if (ds == null || ds.getNewConnectionSql() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getNewConnectionSql()));
                        break;
                    }
                    case 16: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getCheckValidConnectionSql() == null || ds.getValidation().getCheckValidConnectionSql().trim().equals("")) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getCheckValidConnectionSql()));
                        break;
                    }
                    case 17: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getValidConnectionChecker() == null || ds.getValidation().getValidConnectionChecker().getClassName() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getValidConnectionChecker().getClassName()));
                        break;
                    }
                    case 18: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getValidConnectionChecker() == null || ds.getValidation().getValidConnectionChecker().getClassName() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry<String, String> connProperty : ds.getValidation().getValidConnectionChecker().getConfigPropertiesMap().entrySet()) {
                            valueBuf.append(connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append(connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case 19: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getExceptionSorter() == null || ds.getValidation().getExceptionSorter().getClassName() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getExceptionSorter().getClassName()));
                        break;
                    }
                    case 20: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getExceptionSorter() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry<String, String> connProperty : ds.getValidation().getExceptionSorter().getConfigPropertiesMap().entrySet()) {
                            valueBuf.append(connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append(connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case 21: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getStaleConnectionChecker() == null || ds.getValidation().getStaleConnectionChecker().getClassName() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getStaleConnectionChecker().getClassName()));
                        break;
                    }
                    case 22: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getStaleConnectionChecker() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry<String, String> connProperty : ds.getValidation().getStaleConnectionChecker().getConfigPropertiesMap().entrySet()) {
                            valueBuf.append(connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append(connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case 23: {
                        if (ds == null || ds.getStatement() == null || ds.getStatement().getTrackStatements() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getStatement().getTrackStatements().name()));
                        break;
                    }
                    case 24: {
                        if (ds == null || ds.getTimeOut() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTimeOut().isSetTxQueryTimeout()));
                        break;
                    }
                    case 25: {
                        if (ds == null || ds.getTimeOut() == null || ds.getTimeOut().getQueryTimeout() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTimeOut().getQueryTimeout()));
                        break;
                    }
                    case 26: {
                        if (ds == null || ds.getTimeOut() == null || ds.getTimeOut().getUseTryLock() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTimeOut().getUseTryLock()));
                        break;
                    }
                    case 1: {
                        if (ds == null || ds.getDriverClass() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getDriverClass()));
                        break;
                    }
                    case 2: {
                        if (ds == null || ds.getDataSourceClass() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getDataSourceClass()));
                        break;
                    }
                    case 9: {
                        if (xads == null || xads.getUrlProperty() == null || xads.getUrlProperty().trim().equals("")) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, xads.getUrlProperty()));
                        break;
                    }
                    case 4: {
                        if (ds == null || ds.getConnectionProperties() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry<String, String> connProperty : ds.getConnectionProperties().entrySet()) {
                            valueBuf.append(connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append(connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case 3: {
                        if (ds == null || ds.getConnectionUrl() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getConnectionUrl()));
                        break;
                    }
                }
            }
            if (ds != null) {
                for (Map.Entry entry : ds.getConnectionProperties().entrySet()) {
                    prototype = ConfigPropertyFactory.Prototype.forName((String)entry.getKey());
                    if (prototype == ConfigPropertyFactory.Prototype.UNKNOWN) continue;
                    configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, (String)entry.getValue()));
                }
            }
            return configProperties;
        }
        return null;
    }

    public static String encodeConfigProperty(String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.replace(";", ENCODED_SEMICOLON);
    }

    public static String decodeConfigProperty(String encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return encodedValue.replace(ENCODED_SEMICOLON, ";");
    }

    protected static class ConfigPropertyFactory {
        protected ConfigPropertyFactory() {
        }

        public static ConfigProperty createConfigProperty(Prototype prototype, String value) {
            return new ConfigPropertyImpl(prototype.getDescription(), prototype.getLocalName(), prototype.getLocalType(), new XsdString(value, null), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, false, null, null, null, null);
        }

        public static ConfigProperty createConfigProperty(Prototype prototype, boolean value) {
            return new ConfigPropertyImpl(prototype.getDescription(), prototype.getLocalName(), prototype.getLocalType(), new XsdString(String.valueOf(value), null), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, false, null, null, null, null);
        }

        public static ConfigProperty createConfigProperty(Prototype prototype, Number value) {
            return new ConfigPropertyImpl(prototype.getDescription(), prototype.getLocalName(), prototype.getLocalType(), new XsdString(String.valueOf(value), null), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, false, null, null, null, null);
        }

        static enum Prototype {
            UNKNOWN(null, null, null),
            DRIVERCLASS("DriverClass", "java.lang.String", "The jdbc driver class."),
            DATASOURCECLASS("DataSourceClass", "java.lang.String", "The jdbc datasource class."),
            CONNECTIONURL("ConnectionURL", "java.lang.String", "The jdbc connection url class."),
            CONNECTIONPROPERTIES("ConnectionProperties", "java.lang.String", "Connection properties for the database."),
            USERNAME("UserName", "java.lang.String", "The default user name used to create JDBC connections."),
            PASSWORD("Password", "java.lang.String", "The default password used to create JDBC connections."),
            XADATASOURCEPROPERTIES("XADataSourceProperties", "java.lang.String", "The properties to set up the XA driver. These properties must be in the form name1=value1;name2=value2;...namen=valuen"),
            URLDELIMITER("URLDelimiter", "java.lang.String", "The jdbc connection url delimeter."),
            URLPROPERTY("URLProperty", "java.lang.String", "The property that contains the list of URLs."),
            URLSELECTORSTRATEGYCLASSNAME("UrlSelectorStrategyClassName", "java.lang.String", "The configurable URLSelectorStrategy class name."),
            XADATASOURCECLASS("XADataSourceClass", "java.lang.String", "The class name of the JDBC XA driver that handlesthis JDBC URL."),
            TRANSACTIONISOLATION("TransactionIsolation", "java.lang.String", "The transaction isolation for new connections. Not necessary: the driver default will be used if ommitted."),
            PREPAREDSTATEMENTCACHESIZE("PreparedStatementCacheSize", "java.lang.Integer", "The number of cached prepared statements per connection."),
            SHAREPREPAREDSTATEMENTS("SharePreparedStatements", "java.lang.Boolean", "Whether to share prepared statements."),
            NEWCONNECTIONSQL("NewConnectionSQL", "java.lang.String", "An SQL statement to be executed when a new connection is created as auxillary setup."),
            CHECKVALIDCONNECTIONSQL("CheckValidConnectionSQL", "java.lang.String", "An SQL statement that may be executed when a managed connection is taken out of the pool and is about to be given to a client: the purpose is to verify that the connection still works."),
            VALIDCONNECTIONCHECKERCLASSNAME("ValidConnectionCheckerClassName", "java.lang.String", "The fully qualified name of a class implementing org.jboss.jca.adapters.jdbc.ValidConnectionChecker that can determine for a particular vender db when a connection is valid."),
            VALIDCONNECTIONCHECKERPROPERTIES("ValidConnectionCheckerProperties", "java.lang.String", "The properties to inect into class implementing org.jboss.jca.adapters.jdbc.ValidConnectionChecker that can determine for a particular vender db when a connection is valid."),
            EXCEPTIONSORTERCLASSNAME("ExceptionSorterClassName", "java.lang.String", "The fully qualified name of a class implementing org.jboss.jca.adapters.jdbc.ExceptionSorter that can determine for a particular vender db which exceptions are fatal and mean a connection should be discarded."),
            EXCEPTIONSORTERPROPERTIES("ExceptionSorterProperties", "java.lang.String", "The properties to inect into  class implementing org.jboss.jca.adapters.jdbc.ExceptionSorter that can determine for a particular vender db which exceptions are fatal and mean a connection should be discarded."),
            STALECONNECTIONCHECKERCLASSNAME("StaleConnectionCheckerClassName", "java.lang.String", "The fully qualified name of a class implementing org.jboss.jca.adapters.jdbc.StaleConnectionChecker that can determine for a particular vender db when a connection is stale."),
            STALECONNECTIONCHECKERPROPERTIES("StaleConnectionCheckerProperties", "java.lang.String", "The properties to inect into  class implementing org.jboss.jca.adapters.jdbc.StaleConnectionChecker that can determine for a particular vender db when a connection is stale."),
            TRACKSTATEMENTS("TrackStatements", "java.lang.String", "Whether to track unclosed statements - false/true/nowarn"),
            TRANSACTIONQUERYTIMEOUT("TransactionQueryTimeout", "java.lang.Boolean", "Whether to set the query timeout based on the transaction timeout"),
            QUERYTIMEOUT("QueryTimeout", "java.lang.Integer", "A configured query timeout"),
            USETRYLOCK("UseTryLock", "java.lang.Integer", "Maximum wait for a lock");

            private final XsdString localName;
            private final XsdString localType;
            private final ArrayList<LocalizedXsdString> description = new ArrayList(1);
            private static final Map<String, Prototype> MAP;

            private Prototype(String name, String type, String description) {
                this.localName = new XsdString(name, null);
                this.localType = new XsdString(type, null);
                this.description.add(new LocalizedXsdString(description, null));
            }

            public final XsdString getLocalName() {
                return this.localName;
            }

            public final XsdString getLocalType() {
                return this.localType;
            }

            public final List<LocalizedXsdString> getDescription() {
                return this.description;
            }

            public static Prototype forName(String localName) {
                Prototype element = MAP.get(localName);
                return element == null ? UNKNOWN : element;
            }

            static {
                HashMap<String, Prototype> map = new HashMap<String, Prototype>();
                for (Prototype element : Prototype.values()) {
                    String name = element.getLocalName().getValue();
                    if (name == null) continue;
                    map.put(name, element);
                }
                MAP = map;
            }
        }
    }
}

