/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ironjacamar;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CommonIronJacamarParser;
import org.jboss.jca.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.logging.Messages;

public class IronJacamarParser
extends CommonIronJacamarParser
implements MetadataParser<Activation> {
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);

    @Override
    public Activation parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        return this.parse(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Activation parse(XMLStreamReader reader) throws Exception {
        Activation ironJacamar = null;
        try {
            int iterate;
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return ironJacamar;
                }
                case 1: {
                    switch (Tag.forName(reader.getLocalName()).ordinal()) {
                        case 1: {
                            ironJacamar = this.parseIronJacamar(reader);
                            return ironJacamar;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Activation parseIronJacamar(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<ConnectionDefinition> connectionDefinitions = null;
        ArrayList<AdminObject> adminObjects = null;
        ArrayList<String> beanValidationGroups = null;
        String bootstrapContext = null;
        TransactionSupportEnum transactionSupport = null;
        HashMap<String, String> configProperties = null;
        WorkManager workManager = null;
        Boolean isXA = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.IRONJACAMAR) {
                        return new ActivationImpl(null, null, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext, workManager);
                    }
                    if (Activation.Tag.forName(reader.getLocalName()) != Activation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Activation.Tag.forName(reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block0;
                        }
                        case ADMIN_OBJECT: {
                            if (adminObjects == null) {
                                adminObjects = new ArrayList<AdminObject>();
                            }
                            adminObjects.add(this.parseAdminObjects(reader));
                            break block0;
                        }
                        case CONNECTION_DEFINITION: {
                            if (connectionDefinitions == null) {
                                connectionDefinitions = new ArrayList<ConnectionDefinition>();
                            }
                            connectionDefinitions.add(this.parseConnectionDefinitions(reader, isXA));
                            break block0;
                        }
                        case WORKMANAGER: {
                            workManager = this.parseWorkManager(reader);
                            break block0;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            if (beanValidationGroups == null) {
                                beanValidationGroups = new ArrayList<String>();
                            }
                            beanValidationGroups.add(this.elementAsString(reader));
                            break block0;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            bootstrapContext = this.elementAsString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            String n;
                            if (configProperties == null) {
                                configProperties = new HashMap<String, String>();
                            }
                            if ((n = this.attributeAsString(reader, "name")) == null || n.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing("name", reader.getLocalName()));
                            }
                            configProperties.put(n, this.elementAsString(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            transactionSupport = TransactionSupportEnum.valueOf(this.elementAsString(reader));
                            if (transactionSupport != TransactionSupportEnum.XATransaction) break block0;
                            isXA = Boolean.TRUE;
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        IRONJACAMAR("ironjacamar");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

