/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import org.jboss.jdeparser.JAssignmentTarget;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExpression;
import org.jboss.jdeparser.JExpressionImpl;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JGenerable;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JVar;

public class JFieldRef
extends JExpressionImpl
implements JAssignmentTarget {
    private JGenerable object;
    private String name;
    private JVar var;
    private boolean explicitThis;

    JFieldRef(JExpression object, String name) {
        this((JGenerable)object, name, false);
    }

    JFieldRef(JExpression object, JVar v) {
        this((JGenerable)object, v, false);
    }

    JFieldRef(JType type, String name) {
        this((JGenerable)type, name, false);
    }

    JFieldRef(JType type, JVar v) {
        this((JGenerable)type, v, false);
    }

    JFieldRef(JGenerable object, String name, boolean explicitThis) {
        this.explicitThis = explicitThis;
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Field name contains '.': " + name);
        }
        this.name = name;
    }

    JFieldRef(JGenerable object, JVar var, boolean explicitThis) {
        this.explicitThis = explicitThis;
        this.object = object;
        this.var = var;
    }

    @Override
    public void generate(JFormatter f) {
        String name = this.name;
        if (name == null) {
            name = this.var.name();
        }
        if (this.object != null) {
            f.g(this.object).p('.').p(name);
        } else if (this.explicitThis) {
            f.p("this.").p(name);
        } else {
            f.id(name);
        }
    }

    @Override
    public JExpression assign(JExpression rhs) {
        return JExpr.assign(this, rhs);
    }

    @Override
    public JExpression assignPlus(JExpression rhs) {
        return JExpr.assignPlus(this, rhs);
    }
}

