/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.filter;

import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdDatatypeEnum;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class ElementFilter
implements Filter {
    public boolean filter(Metadata metadata, TreeWalker walker) {
        Node parent = walker.getCurrentNode();
        Element element = (Element)parent;
        if (XsdElementEnum.element.isTagNameEqual(element.getTagName())) {
            MetadataItem dataType;
            String dataTypeName;
            String typeStr;
            Node parentNodeWithName;
            String refStr = MetadataUtil.getAttributeValue(element, "ref");
            if (refStr != null && (parentNodeWithName = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name")) != null) {
                Element parentElementWithName = (Element)parentNodeWithName;
                String groupOrClassName = MetadataUtil.getAttributeValue(parentElementWithName, "name");
                if (XsdElementEnum.group.isTagNameEqual(parentElementWithName.getTagName())) {
                    MetadataElement refElement = new MetadataElement(element);
                    refElement.setIsRef(true);
                    metadata.addGroupReference(groupOrClassName, refElement);
                    return true;
                }
                if (XsdElementEnum.attributeGroup.isTagNameEqual(parentElementWithName.getTagName())) {
                    MetadataElement refElement = new MetadataElement(element);
                    refElement.setIsRef(true);
                    metadata.addGroupReference(groupOrClassName, refElement);
                    return true;
                }
                if (XsdElementEnum.element.isTagNameEqual(parentElementWithName.getTagName())) {
                    String[] items;
                    MetadataElement refElement = new MetadataElement(element);
                    Node parentNodeWithMaxOccurs = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "maxOccurs");
                    Element p = (Element)parentNodeWithMaxOccurs;
                    String maxOccurs = MetadataUtil.getAttributeValue(p, "maxOccurs");
                    if (maxOccurs != null && !maxOccurs.equals("1")) {
                        refElement.setMaxOccurs("unbounded");
                    }
                    if ((items = refStr.split(":", -1)).length == 2) {
                        refElement.setName(items[1]);
                    } else {
                        refElement.setName(refStr);
                    }
                    refElement.setType(refStr);
                    metadata.addClassElement(groupOrClassName, refElement);
                    return true;
                }
            }
            if (XsdDatatypeEnum.integer.isDataType(typeStr = MetadataUtil.getAttributeValue(element, "type")) && (dataTypeName = MetadataUtil.getAttributeValue(element, "name")) != null) {
                dataType = new MetadataItem(dataTypeName);
                dataType.setMappedTo(typeStr);
                dataType.setNamespace(metadata.getCurrentNamespace());
                dataType.setSchemaName(metadata.getCurrentSchmema());
                metadata.getDataTypeList().add(dataType);
            }
            if (typeStr == null && !element.hasChildNodes()) {
                dataTypeName = MetadataUtil.getAttributeValue(element, "name");
                dataType = new MetadataItem(dataTypeName);
                dataType.setMappedTo("xs:string");
                dataType.setNamespace(metadata.getCurrentNamespace());
                dataType.setSchemaName(metadata.getCurrentSchmema());
                metadata.getDataTypeList().add(dataType);
                return true;
            }
            Node parentNodeWithName2 = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name");
            if (parentNodeWithName2 != null) {
                String maxOccurs;
                Element parentElementWithName = (Element)parentNodeWithName2;
                String groupOrClassName = MetadataUtil.getAttributeValue(parentElementWithName, "name");
                boolean isUnbounded = false;
                Element p = (Element)parent.getParentNode();
                if (p != null && XsdElementEnum.choice.isTagNameEqual(p.getTagName()) && (maxOccurs = MetadataUtil.getAttributeValue(p, "maxOccurs")) != null && !maxOccurs.equals("1")) {
                    isUnbounded = true;
                }
                if (groupOrClassName != null) {
                    if (XsdElementEnum.group.isTagNameEqual(parentElementWithName.getTagName())) {
                        MetadataElement groupElement = new MetadataElement(element);
                        if (isUnbounded) {
                            groupElement.setMaxOccurs("unbounded");
                        }
                        metadata.addGroupElement(groupOrClassName, groupElement);
                        return true;
                    }
                    MetadataElement classElement = new MetadataElement(element);
                    if (isUnbounded) {
                        classElement.setMaxOccurs("unbounded");
                    }
                    metadata.addClassElement(groupOrClassName, classElement);
                    return true;
                }
            }
        }
        return false;
    }
}

