/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata;

import com.sun.xml.dtdparser.DTDParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.jboss.shrinkwrap.descriptor.metadata.FilterChain;
import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataDescriptor;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataParserConfiguration;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataParserPath;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.dom.DomWriter;
import org.jboss.shrinkwrap.descriptor.metadata.dtd.MetadataDtdEventListener;
import org.jboss.shrinkwrap.descriptor.metadata.xslt.XsltTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataParser {
    private static final Logger log = Logger.getLogger(MetadataParser.class.getName());
    private final FilterChain filterChain = new FilterChain();
    private final Metadata metadata = new Metadata();
    private String pathToMetadata;

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void parse(MetadataParserPath path, List<?> confList, List<?> javadocTags, boolean verbose) throws Exception {
        this.checkArguments(path, confList);
        this.pathToMetadata = this.createTempFile(verbose);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Path to temporary metadata file: " + this.pathToMetadata);
        }
        for (int i = 0; i < confList.size(); ++i) {
            MetadataParserConfiguration metadataConf = (MetadataParserConfiguration)confList.get(i);
            this.metadata.setCurrentNamespace(metadataConf.getNameSpace());
            this.metadata.setCurrentSchmema(metadataConf.getPathToXsd());
            this.metadata.setCurrentPackageApi(metadataConf.getPackageApi());
            this.metadata.setCurrentPackageImpl(metadataConf.getPackageImpl());
            MetadataDescriptor metadataDescriptor = new MetadataDescriptor(metadataConf.getDescriptorName());
            metadataDescriptor.setRootElementName(metadataConf.getElementName());
            metadataDescriptor.setRootElementType(metadataConf.getElementType());
            metadataDescriptor.setSchemaName(metadataConf.getPathToXsd());
            metadataDescriptor.setPackageApi(metadataConf.getPackageApi());
            metadataDescriptor.setPackageImpl(metadataConf.getPackageImpl());
            metadataDescriptor.setNamespace(metadataConf.getNameSpace());
            metadataDescriptor.setNamespaces(metadataConf.getNamespaces());
            metadataDescriptor.setGenerateClasses(metadataConf.generateClasses);
            this.metadata.getMetadataDescriptorList().add(metadataDescriptor);
            if (log.isLoggable(Level.FINE)) {
                log.fine(metadataConf.getPathToXsd());
            }
            if (metadataConf.getPathToXsd().endsWith(".dtd")) {
                InputSource in = new InputSource(new FileReader(metadataConf.getPathToXsd()));
                MetadataDtdEventListener dtdEventListener = new MetadataDtdEventListener(this.metadata, verbose);
                DTDParser parser = new DTDParser();
                parser.setDtdHandler(dtdEventListener);
                parser.parse(in);
                continue;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder loader = factory.newDocumentBuilder();
            Document document = loader.parse(metadataConf.getPathToXsd());
            if (log.isLoggable(Level.FINE)) {
                log.fine(document.getDocumentURI());
            }
            DocumentTraversal traversal = (DocumentTraversal)((Object)document);
            TreeWalker walker = traversal.createTreeWalker(document.getDocumentElement(), 1, null, true);
            StringBuilder sb = verbose ? new StringBuilder() : null;
            this.filterChain.traverseAndFilter(walker, "", this.metadata, sb);
            if (sb == null) continue;
            log.info(sb.toString());
        }
        this.metadata.preResolveDataTypes();
        if (this.pathToMetadata != null) {
            new DomWriter().write(this.metadata, this.pathToMetadata, javadocTags);
        }
        if (verbose) {
            new MetadataUtil().log(this.metadata);
        }
        if (path.getPathToApi() != null && path.getPathToImpl() != null) {
            this.generateCode(path, verbose);
        }
    }

    public void generateCode(MetadataParserPath path, boolean verbose) throws TransformerException {
        HashMap<String, String> xsltParameters = new HashMap<String, String>();
        xsltParameters.put("gOutputFolder", this.getURIPath(path.getPathToImpl()));
        xsltParameters.put("gOutputFolderApi", this.getURIPath(path.getPathToApi()));
        xsltParameters.put("gOutputFolderTest", this.getURIPath(path.getPathToTest()));
        xsltParameters.put("gOutputFolderService", this.getURIPath(path.getPathToServices()));
        xsltParameters.put("gVerbose", Boolean.toString(verbose));
        InputStream is = MetadataParser.class.getResourceAsStream("/META-INF/ddJavaAll.xsl");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stream resource: " + is);
        }
        XsltTransformer.simpleTransform(this.pathToMetadata, is, new File("./tempddJava.xml"), xsltParameters);
    }

    private String getURIPath(String path) {
        if (path != null) {
            return new File(path).toURI().getPath();
        }
        return "";
    }

    public String getPathToMetadataFile() {
        return this.pathToMetadata;
    }

    private String createTempFile(boolean verbose) throws IOException {
        File tempFile = File.createTempFile("tempMetadata", ".xml");
        if (!verbose) {
            tempFile.deleteOnExit();
        }
        return tempFile.getAbsolutePath();
    }

    private void checkArguments(MetadataParserPath path, List<?> confList) {
        if (path == null) {
            throw new IllegalArgumentException("Invalid configuration. The 'path' element missing!");
        }
        if (confList == null) {
            throw new IllegalArgumentException("Invalid configuration. At least one 'descriptor' element has to be defined!");
        }
        if (confList.isEmpty()) {
            throw new IllegalArgumentException("Invalid configuration. At least one 'descriptor' element has to be defined!");
        }
    }
}

