/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.io.Writer;

class CountingWriter
extends Writer {
    private final char[] buffer = new char[4096];
    private final Writer out;
    private int line = 1;
    private int column = 1;
    private int bsz;

    CountingWriter(Writer out) {
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        int line = this.line;
        int column = this.column;
        int bsz = this.bsz;
        char[] buffer = this.buffer;
        try {
            for (int i = 0; i < len; ++i) {
                char ch = chars[off + i];
                if (ch == '\n') {
                    ++line;
                    column = 1;
                } else {
                    column = ch == '\r' ? 1 : ++column;
                }
                buffer[bsz++] = ch;
                if (bsz != buffer.length) continue;
                this.out.write(buffer, 0, bsz);
                bsz = 0;
            }
        }
        finally {
            this.line = line;
            this.column = column;
            this.bsz = bsz;
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (c == 10) {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        this.buffer[this.bsz++] = (char)c;
        if (this.bsz == this.buffer.length) {
            this.out.write(this.buffer, 0, this.bsz);
            this.bsz = 0;
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int off, int len) throws IOException {
        int line = this.line;
        int column = this.column;
        int bsz = this.bsz;
        char[] buffer = this.buffer;
        try {
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(off + i);
                if (ch == '\n') {
                    ++line;
                    column = 1;
                } else {
                    column = ch == '\r' ? 1 : ++column;
                }
                buffer[bsz++] = ch;
                if (bsz != buffer.length) continue;
                this.out.write(buffer, 0, bsz);
                bsz = 0;
            }
        }
        finally {
            this.line = line;
            this.column = column;
            this.bsz = bsz;
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(StringBuilder b, int off, int len) throws IOException {
        int line = this.line;
        int column = this.column;
        int bsz = this.bsz;
        char[] buffer = this.buffer;
        try {
            for (int i = 0; i < len; ++i) {
                char ch = b.charAt(off + i);
                if (ch == '\n') {
                    ++line;
                    column = 1;
                } else {
                    column = ch == '\r' ? 1 : ++column;
                }
                buffer[bsz++] = ch;
                if (bsz != buffer.length) continue;
                this.out.write(buffer, 0, bsz);
                bsz = 0;
            }
        }
        finally {
            this.line = line;
            this.column = column;
            this.bsz = bsz;
        }
    }

    public void write(StringBuilder b) throws IOException {
        this.write(b, 0, b.length());
    }

    @Override
    public void flush() throws IOException {
        int bsz = this.bsz;
        this.bsz = 0;
        this.out.write(this.buffer, 0, bsz);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        int bsz = this.bsz;
        this.bsz = 0;
        this.out.write(this.buffer, 0, bsz);
        this.out.close();
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }
}

