/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator.maven;

import java.io.File;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.jca.validator.Validation;
import org.jboss.jca.validator.maven.SecurityActions;

public class ValidatorMojo
extends AbstractMojo {
    private String outputDir = ".";
    private File rarFile;
    private String[] classpath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldCL = SecurityActions.getThreadContextClassLoader();
        try {
            SecurityActions.setThreadContextClassLoader(SecurityActions.getClassLoader(ValidatorMojo.class));
            Validation.validate((URL)this.getRarFile().toURI().toURL(), (String)this.getOutputDir(), (String[])this.getClasspath());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldCL);
        }
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public File getRarFile() {
        return this.rarFile;
    }

    public void setRarFile(File rarFile) {
        this.rarFile = rarFile;
    }

    public void setClasspath(String[] classpath) {
        this.classpath = classpath;
    }

    public String[] getClasspath() {
        return this.classpath;
    }
}

