/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.web;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jboss.logging.Logger;

public class ExecutorThreadPool
extends AbstractLifeCycle
implements ThreadPool {
    private static Logger log = Logger.getLogger(ExecutorThreadPool.class);
    private final ExecutorService executor;

    public ExecutorThreadPool(ExecutorService executor) {
        this.executor = executor;
    }

    public boolean dispatch(Runnable job) {
        try {
            this.executor.execute(job);
            return true;
        }
        catch (RejectedExecutionException e) {
            log.warn((Object)"Dispatch rejected", (Throwable)e);
            return false;
        }
    }

    public int getIdleThreads() {
        if (this.executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.executor;
            return tpe.getPoolSize() - tpe.getActiveCount();
        }
        return -1;
    }

    public int getThreads() {
        if (this.executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.executor;
            return tpe.getPoolSize();
        }
        return -1;
    }

    public boolean isLowOnThreads() {
        if (this.executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.executor;
            return tpe.getActiveCount() >= tpe.getMaximumPoolSize();
        }
        return false;
    }

    public void join() throws InterruptedException {
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

