/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.jca.adapters.jdbc.vendor;

import org.jboss.jca.adapters.jdbc.ValidConnectionChecker;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * A PostgreSQLValidConnectionChecker.
 * 
 * @author <a href="weston.price@jboss.com">Weston Price</a>
 * @version $Revision: 71554 $
 */
public class PostgreSQLValidConnectionChecker implements ValidConnectionChecker, Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 4867167301823753925L;

   /**
    * Constructor
    */
   public PostgreSQLValidConnectionChecker()
   {
   }

   /**
    * {@inheritDoc}
    */
   public SQLException isValidConnection(Connection c)
   {
      Statement stmt = null;
      SQLException sqe = null;
      
      try
      {
         stmt = c.createStatement();
         stmt.execute("");
      }
      catch (Exception e)
      {
         if (e instanceof SQLException)
         {
            sqe = (SQLException)e;
         }
      }
      finally
      {
         if (stmt != null)
         {
            try
            {
               stmt.close();
            }
            catch (SQLException e)
            {
               // Ignore
            }
         }
      }
      
      return sqe;
   }
}
