/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.WrappedStatement;
import org.jboss.logging.Logger;

public abstract class WrappedResultSet
extends JBossWrapper
implements ResultSet {
    protected static Logger spyLogger = Logger.getLogger((String)"jboss.jdbc.spy");
    private WrappedStatement statement;
    private ResultSet resultSet;
    private AtomicBoolean closed = new AtomicBoolean(false);
    protected final boolean spy;
    protected final String jndiName;
    protected static Integer defaultFetchSize = null;
    protected final boolean doLocking;

    public WrappedResultSet(WrappedStatement statement, ResultSet resultSet, boolean spy, String jndiName, boolean doLocking) {
        if (statement == null) {
            throw new IllegalArgumentException("Null statement!");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("Null result set!");
        }
        this.statement = statement;
        this.resultSet = resultSet;
        this.spy = spy;
        this.jndiName = jndiName;
        this.doLocking = doLocking;
        if (defaultFetchSize != null) {
            try {
                resultSet.setFetchSize(defaultFetchSize);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public ResultSet getUnderlyingResultSet() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            ResultSet resultSet = this.resultSet;
            return resultSet;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] absolute(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)row);
                }
                boolean bl = this.resultSet.absolute(row);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] afterLast()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.afterLast();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] beforeFirst()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.beforeFirst();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] cancelRowUpdates()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.cancelRowUpdates();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] clearWarnings()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.clearWarnings();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            if (this.closed.get()) {
                return;
            }
            if (this.spy) {
                spyLogger.debugf("%s [%s] close()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.closed.set(true);
            this.statement.unregisterResultSet(this);
            this.internalClose();
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] deleteRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.deleteRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] findColumn(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                int n = this.resultSet.findColumn(columnName);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] first()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.first();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
                }
                Array array = this.resultSet.getArray(i);
                return array;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
                }
                Array array = this.resultSet.getArray(colName);
                return array;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getAsciiStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                InputStream inputStream = this.resultSet.getAsciiStream(columnIndex);
                return inputStream;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getAsciiStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                InputStream inputStream = this.resultSet.getAsciiStream(columnName);
                return inputStream;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                BigDecimal bigDecimal = this.resultSet.getBigDecimal(columnIndex);
                return bigDecimal;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, scale});
                }
                BigDecimal bigDecimal = this.resultSet.getBigDecimal(columnIndex, scale);
                return bigDecimal;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                BigDecimal bigDecimal = this.resultSet.getBigDecimal(columnName);
                return bigDecimal;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, scale});
                }
                BigDecimal bigDecimal = this.resultSet.getBigDecimal(columnName, scale);
                return bigDecimal;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBinaryStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                InputStream inputStream = this.resultSet.getBinaryStream(columnIndex);
                return inputStream;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBinaryStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                InputStream inputStream = this.resultSet.getBinaryStream(columnName);
                return inputStream;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
                }
                Blob blob = this.resultSet.getBlob(i);
                return blob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
                }
                Blob blob = this.resultSet.getBlob(colName);
                return blob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                boolean bl = this.resultSet.getBoolean(columnIndex);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                boolean bl = this.resultSet.getBoolean(columnName);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                byte by = this.resultSet.getByte(columnIndex);
                return by;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                byte by = this.resultSet.getByte(columnName);
                return by;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                byte[] byArray = this.resultSet.getBytes(columnIndex);
                return byArray;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                byte[] byArray = this.resultSet.getBytes(columnName);
                return byArray;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                Reader reader = this.resultSet.getCharacterStream(columnIndex);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                Reader reader = this.resultSet.getCharacterStream(columnName);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
                }
                Clob clob = this.resultSet.getClob(i);
                return clob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
                }
                Clob clob = this.resultSet.getClob(colName);
                return clob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getConcurrency()", (Object)this.jndiName, (Object)"ResultSet");
                }
                int n = this.resultSet.getConcurrency();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getCursorName()", (Object)this.jndiName, (Object)"ResultSet");
                }
                String string = this.resultSet.getCursorName();
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                Date date = this.resultSet.getDate(columnIndex);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, cal});
                }
                Date date = this.resultSet.getDate(columnIndex, cal);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                Date date = this.resultSet.getDate(columnName);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, cal});
                }
                Date date = this.resultSet.getDate(columnName, cal);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                double d = this.resultSet.getDouble(columnIndex);
                return d;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                double d = this.resultSet.getDouble(columnName);
                return d;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFetchDirection()", (Object)this.jndiName, (Object)"ResultSet");
                }
                int n = this.resultSet.getFetchDirection();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFetchSize()", (Object)this.jndiName, (Object)"ResultSet");
                }
                int n = this.resultSet.getFetchSize();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                float f = this.resultSet.getFloat(columnIndex);
                return f;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                float f = this.resultSet.getFloat(columnName);
                return f;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                int n = this.resultSet.getInt(columnIndex);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                int n = this.resultSet.getInt(columnName);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                long l = this.resultSet.getLong(columnIndex);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                long l = this.resultSet.getLong(columnName);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMetaData()", (Object)this.jndiName, (Object)"ResultSet");
                }
                ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
                return resultSetMetaData;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                Object object = this.resultSet.getObject(columnIndex);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", i, map});
                }
                Object object = this.resultSet.getObject(i, map);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                Object object = this.resultSet.getObject(columnName);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", colName, map});
                }
                Object object = this.resultSet.getObject(colName, map);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
                }
                Ref ref = this.resultSet.getRef(i);
                return ref;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
                }
                Ref ref = this.resultSet.getRef(colName);
                return ref;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getRow() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                int n = this.resultSet.getRow();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                short s = this.resultSet.getShort(columnIndex);
                return s;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                short s = this.resultSet.getShort(columnName);
                return s;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getStatement()", (Object)this.jndiName, (Object)"ResultSet");
                }
                WrappedStatement wrappedStatement = this.statement;
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                String string = this.resultSet.getString(columnIndex);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                String string = this.resultSet.getString(columnName);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                Time time = this.resultSet.getTime(columnIndex);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, cal});
                }
                Time time = this.resultSet.getTime(columnIndex, cal);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                Time time = this.resultSet.getTime(columnName);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, cal});
                }
                Time time = this.resultSet.getTime(columnName, cal);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                Timestamp timestamp = this.resultSet.getTimestamp(columnIndex);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, cal});
                }
                Timestamp timestamp = this.resultSet.getTimestamp(columnIndex, cal);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                Timestamp timestamp = this.resultSet.getTimestamp(columnName);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, cal});
                }
                Timestamp timestamp = this.resultSet.getTimestamp(columnName, cal);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getType() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getType()", (Object)this.jndiName, (Object)"ResultSet");
                }
                int n = this.resultSet.getType();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getUnicodeStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                InputStream inputStream = this.resultSet.getUnicodeStream(columnIndex);
                return inputStream;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getUnicodeStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                InputStream inputStream = this.resultSet.getUnicodeStream(columnName);
                return inputStream;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                URL uRL = this.resultSet.getURL(columnIndex);
                return uRL;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                URL uRL = this.resultSet.getURL(columnName);
                return uRL;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getWarnings()", (Object)this.jndiName, (Object)"ResultSet");
                }
                SQLWarning sQLWarning = this.resultSet.getWarnings();
                return sQLWarning;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void insertRow() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] insertRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.insertRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isAfterLast()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.isAfterLast();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isBeforeFirst()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.isBeforeFirst();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isFirst()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.isFirst();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isLast()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.isLast();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean last() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] last()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.last();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] moveToCurrentRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.moveToCurrentRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] moveToInsertRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.moveToInsertRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] next()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.next();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] previous()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.previous();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] refreshRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.refreshRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] relative(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)rows);
                }
                boolean bl = this.resultSet.relative(rows);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] rowDeleted()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.rowDeleted();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] rowInserted()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.rowInserted();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] rowUpdated()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.rowUpdated();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setFetchDirection(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)direction);
                }
                this.resultSet.setFetchDirection(direction);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setFetchSize(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)rows);
                }
                this.resultSet.setFetchSize(rows);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateArray(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateArray(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateArray(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateArray(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
                }
                this.resultSet.updateAsciiStream(columnIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x, length});
                }
                this.resultSet.updateAsciiStream(columnName, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateBigDecimal(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateBigDecimal(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
                }
                this.resultSet.updateBinaryStream(columnIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x, length});
                }
                this.resultSet.updateBinaryStream(columnName, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateBlob(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateBlob(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBoolean(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateBoolean(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBoolean(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateBoolean(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateByte(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateByte(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateByte(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateByte(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBytes(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, Arrays.toString(x)});
                }
                this.resultSet.updateBytes(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBytes(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, Arrays.toString(x)});
                }
                this.resultSet.updateBytes(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
                }
                this.resultSet.updateCharacterStream(columnIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, reader, length});
                }
                this.resultSet.updateCharacterStream(columnName, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateClob(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateClob(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateDate(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateDate(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateDouble(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateDouble(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateDouble(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateDouble(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateFloat(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, Float.valueOf(x)});
                }
                this.resultSet.updateFloat(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateFloat(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, Float.valueOf(x)});
                }
                this.resultSet.updateFloat(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateInt(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateInt(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateInt(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateInt(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateLong(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateLong(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateLong(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateLong(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNull(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                this.resultSet.updateNull(columnIndex);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNull(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
                }
                this.resultSet.updateNull(columnName);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateObject(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateObject(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, scale});
                }
                this.resultSet.updateObject(columnIndex, x, scale);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateObject(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateObject(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x, scale});
                }
                this.resultSet.updateObject(columnName, x, scale);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateRef(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateRef(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateRef(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateRef(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.updateRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateShort(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateShort(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateShort(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateShort(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateString(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(String columnName, String x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateString(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateTime(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateTime(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateTimestamp(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
                }
                this.resultSet.updateTimestamp(columnName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] wasNull()", (Object)this.jndiName, (Object)"ResultSet");
                }
                boolean bl = this.resultSet.wasNull();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getHoldability()", (Object)this.jndiName, (Object)"ResultSet");
                }
                int n = this.resultSet.getHoldability();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                Reader reader = this.resultSet.getNCharacterStream(columnIndex);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
                }
                Reader reader = this.resultSet.getNCharacterStream(columnLabel);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                NClob nClob = this.resultSet.getNClob(columnIndex);
                return nClob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
                }
                NClob nClob = this.resultSet.getNClob(columnLabel);
                return nClob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                String string = this.resultSet.getNString(columnIndex);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
                }
                String string = this.resultSet.getNString(columnLabel);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                RowId rowId = this.resultSet.getRowId(columnIndex);
                return rowId;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
                }
                RowId rowId = this.resultSet.getRowId(columnLabel);
                return rowId;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
                }
                SQLXML sQLXML = this.resultSet.getSQLXML(columnIndex);
                return sQLXML;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
                }
                SQLXML sQLXML = this.resultSet.getSQLXML(columnLabel);
                return sQLXML;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] isClosed()", (Object)this.jndiName, (Object)"ResultSet");
            }
            if (this.resultSet == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.resultSet.isClosed();
            return bl;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
                }
                this.resultSet.updateAsciiStream(columnIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateAsciiStream(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x, length});
                }
                this.resultSet.updateAsciiStream(columnLabel, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x});
                }
                this.resultSet.updateAsciiStream(columnLabel, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
                }
                this.resultSet.updateBinaryStream(columnIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateBinaryStream(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x, length});
                }
                this.resultSet.updateBinaryStream(columnLabel, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x});
                }
                this.resultSet.updateBinaryStream(columnLabel, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBlob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, inputStream, length});
                }
                this.resultSet.updateBlob(columnIndex, inputStream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, inputStream});
                }
                this.resultSet.updateBlob(columnIndex, inputStream);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBlob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, inputStream, length});
                }
                this.resultSet.updateBlob(columnLabel, inputStream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, inputStream});
                }
                this.resultSet.updateBlob(columnLabel, inputStream);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
                }
                this.resultSet.updateCharacterStream(columnIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateCharacterStream(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
                }
                this.resultSet.updateCharacterStream(columnLabel, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
                }
                this.resultSet.updateCharacterStream(columnLabel, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader, length});
                }
                this.resultSet.updateClob(columnIndex, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader});
                }
                this.resultSet.updateClob(columnIndex, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
                }
                this.resultSet.updateClob(columnLabel, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
                }
                this.resultSet.updateClob(columnLabel, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
                }
                this.resultSet.updateNCharacterStream(columnIndex, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateNCharacterStream(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
                }
                this.resultSet.updateNCharacterStream(columnLabel, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
                }
                this.resultSet.updateNCharacterStream(columnLabel, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, clob});
                }
                this.resultSet.updateNClob(columnIndex, clob);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader, length});
                }
                this.resultSet.updateNClob(columnIndex, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader});
                }
                this.resultSet.updateNClob(columnIndex, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, clob});
                }
                this.resultSet.updateNClob(columnLabel, clob);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
                }
                this.resultSet.updateNClob(columnLabel, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
                }
                this.resultSet.updateNClob(columnLabel, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, string});
                }
                this.resultSet.updateNString(columnIndex, string);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateNString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, string});
                }
                this.resultSet.updateNString(columnLabel, string);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateRowId(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
                }
                this.resultSet.updateRowId(columnIndex, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateRowId(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x});
                }
                this.resultSet.updateRowId(columnLabel, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateSQLXML(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, xmlObject});
                }
                this.resultSet.updateSQLXML(columnIndex, xmlObject);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateSQLXML(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, xmlObject});
                }
                this.resultSet.updateSQLXML(columnLabel, xmlObject);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            T t;
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", parameterIndex, type});
                }
                t = this.resultSet.getObject(parameterIndex, type);
            }
            catch (Throwable t2) {
                throw this.checkException(t2);
            }
            return t;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            T t;
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", parameterName, type});
                }
                t = this.resultSet.getObject(parameterName, type);
            }
            catch (Throwable t2) {
                throw this.checkException(t2);
            }
            return t;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    protected ResultSet getWrappedObject() throws SQLException {
        return this.resultSet;
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        throw this.statement.checkException(t);
    }

    void internalClose() throws SQLException {
        this.closed.set(true);
        this.resultSet.close();
    }

    protected void checkState() throws SQLException {
        if (this.closed.get()) {
            throw new SQLException(bundle.resultSetClosed());
        }
    }

    protected void checkTransaction() throws SQLException {
        this.checkState();
        this.statement.checkTransactionActive();
    }

    protected void lock() throws SQLException {
        this.statement.lock();
    }

    protected void unlock() {
        this.statement.unlock();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof WrappedResultSet) {
            return this.resultSet.equals(((WrappedResultSet)o).resultSet);
        }
        if (o instanceof ResultSet) {
            return this.resultSet.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.resultSet.hashCode();
    }

    public String toString() {
        return this.resultSet.toString();
    }

    static {
        String dfs = SecurityActions.getSystemProperty("ironjacamar.jdbc.defaultfetchsize");
        if (dfs != null) {
            defaultFetchSize = Integer.valueOf(dfs);
        }
    }
}

