/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.util.objectweb.asm.AnnotationVisitor;
import org.jboss.reflect.util.objectweb.asm.Attribute;
import org.jboss.reflect.util.objectweb.asm.ClassReader;
import org.jboss.reflect.util.objectweb.asm.FieldVisitor;
import org.jboss.reflect.util.objectweb.asm.Opcodes;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class AsmFieldBytes extends AsmMemberBytes implements FieldBytes
{
   public AsmFieldBytes(AsmClassBytes clazz, int modifiers, String name, String desc, String signature, int byteCodeIndex)
   {
      super(clazz, modifiers, name, desc, signature, byteCodeIndex);
   }

   public Annotation[] getAnnotations()
   {
      LoadFieldAnnotationsVisitor visitor = new LoadFieldAnnotationsVisitor();
      getClazz().getReader().readField(visitor, AsmClassBytes.STANDARD_FLAGS | ClassReader.INCLUDE_FIELD_ANNOTATIONS, new Attribute[0], null, getByteCodeIndex());
      return visitor.getAnnotations();
   }

   public boolean isEnumConstant()
   {
      return (getModifiers() & Opcodes.ACC_ENUM) == Opcodes.ACC_ENUM;
   }
   
   class LoadFieldAnnotationsVisitor extends  Util.EmptyClassVisitor
   {
      List<Annotation> annotations;

      @Override
      public FieldVisitor visitField(int access, String name, String desc, String signature, Object value, int index)
      {
         if (AsmFieldBytes.this.getByteCodeIndex() == index)
            return new FieldAnnotationVisitor();
         return null;
      }
      
      public Annotation[] getAnnotations()
      {
         if (annotations == null)
            return AsmClassBytes.NO_ANNOTATIONS;
         return annotations.toArray(new Annotation[0]);
      }
      
      class FieldAnnotationVisitor extends Util.EmptyFieldVisitor implements Util.ParentReader
      {
         public AnnotationVisitor visitAnnotation(String desc, boolean visible)
         {
            return Util.createAnnotationVisitor(this, AsmFieldBytes.this.getClazz().getClassLoader(), desc);
         }

         public void setValueInParent(String name, Object value)
         {
            if (annotations == null)
               annotations = new ArrayList<Annotation>();
            annotations.add((Annotation)value);
         }
         
      }
   }   
}
