/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytesFactory;
import org.jboss.reflect.plugins.bytecode.bytes.PrimitiveBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmArrayBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmPrimitiveClassBytes;

public class AsmClassBytesFactory
implements ClassBytesFactory {
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Map<ClassLoader, Map<String, ClassBytes>> cache = new WeakHashMap<ClassLoader, Map<String, ClassBytes>>();
    public static final AsmClassBytesFactory INSTANCE = new AsmClassBytesFactory();
    static final Map<String, PrimitiveBytes> PRIMITIVES = new HashMap<String, PrimitiveBytes>();

    private AsmClassBytesFactory() {
    }

    static void addPrimitive(PrimitiveBytes primitive) {
        PRIMITIVES.put(primitive.getJvmName(), primitive);
        PRIMITIVES.put(primitive.getArrayComponentName(), primitive);
    }

    public ClassBytes loadPrimitive(String name) {
        return PRIMITIVES.get(name);
    }

    public ClassBytes loadClassBytes(ClassLoader initiating, String name) {
        if (initiating == null) {
            throw new IllegalArgumentException("Null initiating classloader");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        ClassLoader cl = initiating;
        ClassBytes clazz = this.findInCache(initiating, name);
        if (clazz != null) {
            return clazz;
        }
        int array = name.indexOf("[]", name.length() - 2);
        if (array > -1) {
            ClassBytes component = null;
            String componentName = name.substring(0, name.length() - 2);
            if (!componentName.endsWith("]")) {
                component = this.loadPrimitive(name);
            }
            if (component == null) {
                component = this.loadClassBytes(initiating, componentName);
            }
            if (component == null) {
                return null;
            }
            clazz = new AsmArrayBytes(component);
        } else {
            clazz = this.loadPrimitive(name);
            if (clazz != null) {
                return clazz;
            }
            URL url = initiating.getResource(name + ".class");
            if (url == null) {
                return null;
            }
            clazz = new AsmClassBytes(cl, url, name);
        }
        if (clazz != null) {
            this.putInCache(initiating, name, clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassBytes findInCache(ClassLoader loader, String name) {
        this.lockRead();
        try {
            Map<String, ClassBytes> classes = this.cache.get(loader);
            if (classes == null) {
                ClassBytes classBytes = null;
                return classBytes;
            }
            ClassBytes classBytes = classes.get(name);
            return classBytes;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(ClassLoader loader, String name, ClassBytes clazz) {
        this.lockWrite();
        try {
            Map<String, ClassBytes> classes = this.cache.get(loader);
            if (classes == null) {
                classes = new HashMap<String, ClassBytes>();
                this.cache.put(loader, classes);
            }
            classes.put(name, clazz);
        }
        finally {
            this.unlockWrite();
        }
    }

    private void lockRead() {
        this.lock.readLock().lock();
    }

    private void unlockRead() {
        this.lock.readLock().unlock();
    }

    private void lockWrite() {
        this.lock.writeLock().lock();
    }

    private void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    static {
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.BOOLEAN);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.CHAR);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.BYTE);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.SHORT);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.INT);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.LONG);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.FLOAT);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.DOUBLE);
        AsmClassBytesFactory.addPrimitive(AsmPrimitiveClassBytes.VOID);
    }
}

