/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.accessor.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class ReflectFieldAccessor implements FieldAccessor
{
   final Field field;

   /** The permission */
   private static Permission accessCheck = new ReflectPermission("suppressAccessChecks");

   ReflectFieldAccessor(Field field)
   {
      this.field = field;
      if (!Modifier.isPublic(field.getModifiers()) && field != null)
         setAccessible();
   }

   //TODO this code is duplicated from ReflectFieldInfo and should be extracted somewhere
   
   public Object get(Object target) throws Throwable
   {
      return ReflectionUtils.getField(field, target);
   }

   public void set(Object target, Object value) throws Throwable
   {
      ReflectionUtils.setField(field, target, value);
   }
   
   /**
    * Check access permission.
    */
   protected final void accessCheck() // final because we don't want subclasses to disable it
   {
      accessCheck(Modifier.isPublic(field.getModifiers()));
   }

   /**
    * Check access permission.
    * 
    * @param isPublic whether the field is public
    */
   protected final void accessCheck(final boolean isPublic) // final because we don't want subclasses to disable it
   {
      if (isPublic == false)
      {
         SecurityManager sm = System.getSecurityManager();
         if (sm != null)
            sm.checkPermission(accessCheck);
      }
   }


   /**
    * Set field accessible to true
    */
   private void setAccessible()
   {
      SecurityManager sm = System.getSecurityManager();
      if (sm == null)
         field.setAccessible(true);
      else
         AccessController.doPrivileged(new SetAccessible());
   }

   /**
    * Set accessible privileged block
    */
   private class SetAccessible implements PrivilegedAction<Object>
   {
      public Object run()
      {
         field.setAccessible(true);
         return null;
      }
   }

   
   
}
