/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class SecurityActions
{
   static ClassLoader getContextClassLoader()
   {
      if (System.getSecurityManager() == null)
         return Thread.currentThread().getContextClassLoader();
      else
         return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
   }

   static class GetContextClassLoaderAction implements PrivilegedAction<ClassLoader>
   {
      final static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

      public ClassLoader run()
      {
         return Thread.currentThread().getContextClassLoader();
      }
   }
   
   static ClassLoader getSystemClassLoader()
   {
      if (System.getSecurityManager() == null)
         return ClassLoader.getSystemClassLoader();
      else
         return AccessController.doPrivileged(GetSystemClassLoaderAction.INSTANCE);
   }

   static class GetSystemClassLoaderAction implements PrivilegedAction<ClassLoader>
   {
      final static GetSystemClassLoaderAction INSTANCE = new GetSystemClassLoaderAction();

      public ClassLoader run()
      {
         return ClassLoader.getSystemClassLoader();
      }
   }
   
   static Class<?> loadClass(final ClassLoader loader, final String name) throws ClassNotFoundException
   {
      if (System.getSecurityManager() == null)
         return loader.loadClass(name);
      
      try
      {
         return AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>()
         {
            public Class<?> run() throws Exception
            {
               return loader.loadClass(name);
            }
         });
      }
      catch (PrivilegedActionException e)
      {
         if (e.getCause() instanceof ClassNotFoundException)
            throw (ClassNotFoundException)e.getCause();
         if (e.getCause() instanceof RuntimeException)
            throw (RuntimeException)e.getCause();
         throw new RuntimeException(e.getCause());
         
      }
   }
   
   static Properties getSystemProperties()
   {
      if (System.getSecurityManager() == null)
         return System.getProperties();
      else
         return AccessController.doPrivileged(GetSystemPropertiesAction.INSTANCE);
   }

   static class GetSystemPropertiesAction implements PrivilegedAction<Properties>
   {
      final static GetSystemPropertiesAction INSTANCE = new GetSystemPropertiesAction();

      public Properties run()
      {
         return System.getProperties();
      }
   }
}
