/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreIterator;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowserMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjStoreBrowser
implements ObjStoreBrowserMBean {
    private static final String SUBORDINATE_AA_TYPE = "StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction/SubordinateAtomicAction/JCA";
    private static OSBType[] defaultOsbTypes = new OSBType[]{new OSBType(true, "com.arjuna.ats.internal.jta.recovery.arjunacore.RecoverConnectableAtomicAction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.RecoverConnectableAtomicActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/AtomicActionConnectable"), new OSBType(false, "com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.SubordinateActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction/SubordinateAtomicAction/JCA"), new OSBType(true, "com.arjuna.ats.arjuna.AtomicAction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.JTAActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction"), new OSBType(true, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ArjunaTransactionImpleWrapper", "com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple")};
    private Map<String, OSBType> osbTypeMap = new HashMap<String, OSBType>();
    public static final String OBJ_STORE_BROWSER_HANDLERS = "com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowserHandlers";
    private static final String STORE_MBEAN_NAME = "jboss.jta:type=ObjectStore";
    private Map<String, List<UidWrapper>> allUids;
    private boolean exposeAllLogs = false;

    public void start() {
        JMXServer.getAgent().registerMBean(STORE_MBEAN_NAME, this);
    }

    public void stop() {
        for (List<UidWrapper> uids : this.allUids.values()) {
            Iterator<UidWrapper> i = uids.iterator();
            while (i.hasNext()) {
                UidWrapper w = i.next();
                i.remove();
                w.unregister();
            }
        }
        JMXServer.getAgent().unregisterMBean(STORE_MBEAN_NAME);
    }

    @Deprecated
    public void setTypes(Map<String, String> types) {
    }

    public boolean setType(String osTypeClassName, String beanTypeClassName) {
        try {
            Class<?> cls = Class.forName(osTypeClassName);
            StateManager sm = (StateManager)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            String typeName = sm.type();
            if (typeName != null && typeName.startsWith("/")) {
                typeName = typeName.substring(1);
            }
            this.osbTypeMap.put(typeName, new OSBType(true, osTypeClassName, beanTypeClassName, typeName));
            return true;
        }
        catch (Exception e) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)("Invalid class type in system property ObjStoreBrowserHandlers: " + osTypeClassName));
            }
            return false;
        }
    }

    private void initTypeHandlers(String handlers) {
        for (String h : handlers.split(",")) {
            String[] handler = h.split("=");
            if (handler.length != 2) continue;
            this.setType(handler[0], handler[1]);
        }
    }

    private void init(String logDir) {
        if (logDir != null) {
            arjPropertyManager.getObjectStoreEnvironmentBean().setObjectStoreDir(logDir);
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ObjectStoreDir: " + arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir()));
        }
        this.setExposeAllRecordsAsMBeans(arjPropertyManager.getObjectStoreEnvironmentBean().getExposeAllLogRecordsAsMBeans());
        for (OSBType osbType : defaultOsbTypes) {
            this.osbTypeMap.put(osbType.typeName, osbType);
        }
        this.allUids = new HashMap<String, List<UidWrapper>>();
        this.initTypeHandlers(System.getProperty(OBJ_STORE_BROWSER_HANDLERS, ""));
    }

    public ObjStoreBrowser() {
        this.init(null);
    }

    public ObjStoreBrowser(String logDir) {
        this.init(logDir);
    }

    public StringBuilder dump(StringBuilder sb) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.allUids.entrySet()) {
            sb.append(typeEntry.getKey()).append('\n');
            for (UidWrapper uid : typeEntry.getValue()) {
                uid.toString("\t", sb);
            }
        }
        return sb;
    }

    public UidWrapper findUid(Uid uid) {
        return this.findUid(uid.stringForm());
    }

    public UidWrapper findUid(String uid) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.allUids.entrySet()) {
            for (UidWrapper w : typeEntry.getValue()) {
                if (!w.getUid().stringForm().equals(uid)) continue;
                return w;
            }
        }
        return null;
    }

    @Override
    public void viewSubordinateAtomicActions(boolean enable) {
        OSBType osbType = this.osbTypeMap.get(SUBORDINATE_AA_TYPE);
        if (osbType == null) {
            return;
        }
        osbType.enabled = enable;
        if (!enable) {
            for (List<UidWrapper> uids : this.allUids.values()) {
                Iterator<UidWrapper> i = uids.iterator();
                while (i.hasNext()) {
                    UidWrapper w = i.next();
                    if (!osbType.recordClass.equals(w.getClassName())) continue;
                    i.remove();
                    w.unregister();
                }
            }
        }
    }

    @Override
    public void setExposeAllRecordsAsMBeans(boolean exposeAllLogs) {
        this.exposeAllLogs = exposeAllLogs;
    }

    private RecoveryManagerStatus trySuspendRM() {
        return RecoveryManager.manager().trySuspend(true);
    }

    private void tryResumeRM(RecoveryManagerStatus previousStatus) {
        if (previousStatus.equals((Object)RecoveryManagerStatus.ENABLED)) {
            RecoveryManager.manager().resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void probe() {
        this.updateAllUids();
        Iterator<String> iterator = this.allUids.keySet().iterator();
        RecoveryManagerStatus rmStatus = this.trySuspendRM();
        try {
            while (iterator.hasNext()) {
                String tname = iterator.next();
                List<UidWrapper> uids = this.allUids.get(tname);
                if (uids == null) {
                    uids = new ArrayList<UidWrapper>();
                    this.allUids.put(tname, uids);
                }
                if (!this.exposeAllLogs && !this.osbTypeMap.containsKey(tname)) continue;
                this.updateMBeans(uids, System.currentTimeMillis(), true, tname);
            }
        }
        finally {
            this.tryResumeRM(rmStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UidWrapper> probe(String type) {
        List<UidWrapper> uids;
        if (!this.allUids.containsKey(type)) {
            this.updateAllUids();
        }
        if ((uids = this.allUids.get(type)) != null && uids.size() > 0) {
            RecoveryManagerStatus rmStatus = this.trySuspendRM();
            try {
                this.updateMBeans(uids, System.currentTimeMillis(), false, type);
            }
            finally {
                this.tryResumeRM(rmStatus);
            }
        }
        return uids;
    }

    private void updateAllUids() {
        block5: {
            InputObjectState types = new InputObjectState();
            try {
                String tname;
                if (!StoreManager.getRecoveryStore().allTypes(types)) break block5;
                do {
                    List<UidWrapper> uids;
                    try {
                        tname = types.unpackString();
                    }
                    catch (IOException e1) {
                        tname = "";
                    }
                    if (tname.length() == 0 || (uids = this.allUids.get(tname)) != null) continue;
                    uids = new ArrayList<UidWrapper>();
                    this.allUids.put(tname, uids);
                } while (tname.length() != 0);
            }
            catch (ObjectStoreException e2) {
                if (!tsLogger.logger.isTraceEnabled()) break block5;
                tsLogger.logger.trace((Object)e2.toString());
            }
        }
    }

    private void updateMBeans(List<UidWrapper> uids, long tstamp, boolean register, String type) {
        UidWrapper w;
        Uid u;
        String stateType;
        OSBType osbType = this.osbTypeMap.get(type);
        if (osbType != null && !osbType.enabled) {
            return;
        }
        ObjectStoreIterator iter = new ObjectStoreIterator(StoreManager.getRecoveryStore(), type);
        String beanType = osbType == null ? OSEntryBean.class.getName() : osbType.beanClass;
        String string = stateType = osbType == null ? null : osbType.recordClass;
        while ((u = iter.iterate()) != null && !Uid.nullUid().equals(u)) {
            w = new UidWrapper(this, beanType, type, stateType, u);
            int i = uids.indexOf(w);
            if (i == -1) {
                w.setTimestamp(tstamp);
                uids.add(w);
                w.createMBean();
                if (!register) continue;
                w.register();
                continue;
            }
            uids.get(i).setTimestamp(tstamp);
        }
        Iterator<UidWrapper> i = uids.iterator();
        while (i.hasNext()) {
            w = i.next();
            if (w.getTimestamp() == tstamp) continue;
            if (register) {
                w.unregister();
            }
            i.remove();
        }
    }

    private static class OSBType {
        boolean enabled;
        String recordClass;
        String beanClass;
        String typeName;

        private OSBType(boolean enabled, String recordClass, String beanClass, String typeName) {
            this.enabled = enabled;
            this.recordClass = recordClass;
            this.beanClass = beanClass;
            this.typeName = typeName;
        }
    }
}

