/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.abstractrecords;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.txoj.LockManager;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LockRecord
extends AbstractRecord {
    protected BasicAction actionHandle;
    private LockManager managerAddress;
    private boolean readOnly;
    private String managerType;

    public LockRecord(LockManager lm, BasicAction currAct) {
        this(lm, false, currAct);
    }

    public LockRecord(LockManager lm, boolean rdOnly, BasicAction currAct) {
        super(lm.get_uid(), lm.type(), 1);
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::LockRecord(" + lm.get_uid() + ", " + (this.readOnly ? "PREPARE_READONLY" : "WRITEABLE") + ")"));
        }
        this.actionHandle = currAct;
        this.managerAddress = lm;
        this.readOnly = rdOnly;
        this.managerType = lm.type();
    }

    @Override
    public int typeIs() {
        return 121;
    }

    @Override
    public Object value() {
        return this.managerAddress;
    }

    @Override
    public void setValue(Object o) {
        txojLogger.i18NLogger.warn_LockRecord_1();
    }

    @Override
    public int nestedAbort() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::nestedAbort() for " + this.order()));
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            Uid toRelease = this.actionHandle.get_uid();
            this.actionHandle = this.actionHandle.parent();
            if (!this.managerAddress.releaseAll(toRelease)) {
                txojLogger.i18NLogger.warn_LockRecord_2(toRelease);
                return 8;
            }
        } else {
            txojLogger.i18NLogger.warn_LockRecord_3();
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::nestedCommit() for " + this.order()));
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            Uid toRelease = this.actionHandle.get_uid();
            this.actionHandle = this.actionHandle.parent();
            return this.managerAddress.propagate(toRelease, this.actionHandle.get_uid()) ? 7 : 8;
        }
        txojLogger.i18NLogger.warn_LockRecord_4();
        return 8;
    }

    @Override
    public int nestedPrepare() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::nestedPrepare() for " + this.order()));
        }
        return 0;
    }

    @Override
    public int topLevelAbort() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::topLevelAbort() for " + this.order()));
        }
        return this.nestedAbort();
    }

    @Override
    public int topLevelCommit() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::topLevelCommit() for " + this.order()));
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            if (!this.managerAddress.releaseAll(this.actionHandle.get_uid())) {
                txojLogger.i18NLogger.warn_LockRecord_5(this.actionHandle.get_uid());
                return 8;
            }
        } else {
            txojLogger.i18NLogger.warn_LockRecord_6();
            return 8;
        }
        return 7;
    }

    @Override
    public int topLevelPrepare() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockRecord::topLevelPrepare() for " + this.order()));
        }
        if (this.readOnly) {
            if (this.topLevelCommit() == 7) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringWriter strm = new StringWriter();
        this.print(new PrintWriter(strm));
        return strm.toString();
    }

    @Override
    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("LockRecord");
    }

    @Override
    public boolean restore_state(InputObjectState o, int t) {
        txojLogger.i18NLogger.warn_LockRecord_7(this.type(), this.order());
        return false;
    }

    @Override
    public boolean save_state(OutputObjectState o, int t) {
        return true;
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/LockRecord";
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final String lockType() {
        return this.managerType;
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord ar) {
        return this.order().equals(ar.order()) && this.typeIs() == ar.typeIs() && ((LockRecord)ar).isReadOnly() && !this.readOnly;
    }

    public LockRecord() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockRecord::LockRecord()");
        }
        this.actionHandle = null;
        this.managerAddress = null;
        this.readOnly = false;
        this.managerType = null;
    }
}

