/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import java.io.File;
import java.util.Locale;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.jboss.gradle.plugins.jdocbook.JDocBookPlugin;
import org.jboss.jdocbook.translate.TranslationSource;

public class AbstractTranslationTask
extends DefaultTask {
    private JDocBookPlugin plugin;
    private String translationLanguage;
    private TranslationSourceImpl translationSource;

    public void configure(JDocBookPlugin plugin, String translationLanguage) {
        this.plugin = plugin;
        this.translationLanguage = translationLanguage;
        this.translationSource = new TranslationSourceImpl();
    }

    protected JDocBookPlugin getPlugin() {
        return this.plugin;
    }

    protected TranslationSourceImpl getTranslationSource() {
        return this.translationSource;
    }

    @Input
    public String getTranslationLanguage() {
        return this.translationLanguage;
    }

    @InputDirectory
    public File getTranslationSourceDirectory() {
        return this.plugin.getDirectoryLayout().getTranslationSourceDirectory(this.getTranslationLanguage());
    }

    @OutputDirectory
    public File getTranslationOutputDirectory() {
        return this.plugin.getDirectoryLayout().getTranslationDirectory(this.getTranslationLanguage());
    }

    private class TranslationSourceImpl
    implements TranslationSource {
        private TranslationSourceImpl() {
        }

        public Locale getLanguage() {
            return AbstractTranslationTask.this.plugin.fromLanguageString(AbstractTranslationTask.this.translationLanguage);
        }

        public File resolvePoDirectory() {
            return AbstractTranslationTask.this.getTranslationSourceDirectory();
        }

        public File resolveTranslatedXmlDirectory() {
            return AbstractTranslationTask.this.getTranslationOutputDirectory();
        }
    }
}

