/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.util.ObservableUrlClassLoader;
import org.jboss.gradle.plugins.jdocbook.DirectoryLayout;
import org.jboss.gradle.plugins.jdocbook.GenerateXslFoTask;
import org.jboss.gradle.plugins.jdocbook.JDocBookConfiguration;
import org.jboss.gradle.plugins.jdocbook.JDocBookConvention;
import org.jboss.gradle.plugins.jdocbook.MasterSourceFileResolver;
import org.jboss.gradle.plugins.jdocbook.ProfileTask;
import org.jboss.gradle.plugins.jdocbook.RenderTask;
import org.jboss.gradle.plugins.jdocbook.StyleStagingTask;
import org.jboss.gradle.plugins.jdocbook.SynchronizePoTask;
import org.jboss.gradle.plugins.jdocbook.SynchronizePotTask;
import org.jboss.gradle.plugins.jdocbook.TranslateTask;
import org.jboss.jdocbook.Configuration;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.MasterLanguageDescriptor;
import org.jboss.jdocbook.Profiling;
import org.jboss.jdocbook.ResourceDelegate;
import org.jboss.jdocbook.ValueInjection;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.util.ResourceDelegateSupport;
import org.jboss.jdocbook.util.TranslationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDocBookPlugin
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(JDocBookPlugin.class);
    public static final String STYLES_CONFIG_NAME = "jdocbookStyles";
    public static final String DOCBOOK_CONFIG_NAME = "docbook";
    public static final String STAGE_TASK_GROUP = "stageStyles";
    public static final String TRANSLATE_TASK_GROUP = "translateDocBook";
    public static final String PROFILE_TASK_GROUP = "profileDocBook";
    public static final String RENDER_TASK_GROUP = "renderDocBook";
    private JDocBookConfiguration configuration = new JDocBookConfiguration();
    private Project project;
    private DirectoryLayout directoryLayout;
    private MasterSourceFileResolver masterSourceFileResolver;
    private JDocBookComponentRegistry jDocBookComponentRegistry;
    private boolean scriptClassLoaderExtended = false;

    public JDocBookConfiguration getConfiguration() {
        return this.configuration;
    }

    public Project getProject() {
        return this.project;
    }

    public DirectoryLayout getDirectoryLayout() {
        return this.directoryLayout;
    }

    public JDocBookComponentRegistry getComponentRegistry() {
        return this.jDocBookComponentRegistry;
    }

    public void apply(final Project project) {
        this.project = project;
        project.getConfigurations().add(DOCBOOK_CONFIG_NAME).setVisible(false).setTransitive(false).setDescription("The DocBook artifact(s) to use.");
        project.getConfigurations().add(STYLES_CONFIG_NAME).setVisible(false).setTransitive(true).setDescription("Defines any jDocBook styles artifacts to apply");
        project.getConvention().getPlugins().put("jdocbook", new JDocBookConvention(this));
        this.directoryLayout = new DirectoryLayout(project, this);
        this.masterSourceFileResolver = new MasterSourceFileResolver(this);
        Task translateStage = project.getTasks().add(TRANSLATE_TASK_GROUP);
        translateStage.setDescription("Perform all DocBook translations");
        translateStage.dependsOn(new Object[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getTasks().withType(TranslateTask.class).getAll();
            }
        }});
        StyleStagingTask stagingTask = (StyleStagingTask)project.getTasks().add(STAGE_TASK_GROUP, StyleStagingTask.class);
        stagingTask.setDescription("Stage all jdocbook styles to the staging directory");
        stagingTask.configure(this);
        Task profileStage = project.getTasks().add(PROFILE_TASK_GROUP);
        profileStage.setDescription("Perform all DocBook profiling");
        profileStage.dependsOn(new Object[]{translateStage});
        profileStage.dependsOn(new Object[]{stagingTask});
        profileStage.dependsOn(new Object[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getTasks().withType(ProfileTask.class).getAll();
            }
        }});
        Task renderStage = project.getTasks().add(RENDER_TASK_GROUP);
        renderStage.setDescription("Perform all DocBook formatting");
        renderStage.dependsOn(new Object[]{profileStage});
        renderStage.dependsOn(new Object[]{stagingTask});
        renderStage.dependsOn(new Object[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getTasks().withType(RenderTask.class).getAll();
            }
        }});
        Task docsTask = (Task)project.getTasks().findByName("buildDocs");
        if (docsTask == null) {
            docsTask = project.getTasks().add("buildDocs");
            docsTask.setDescription("Builds all documentation");
        }
        docsTask.dependsOn(new Object[]{renderStage});
        SynchronizePotTask potTask = (SynchronizePotTask)project.getTasks().add("updatePot", SynchronizePotTask.class);
        potTask.setDescription("Update the POT files from the current state of the master language sources");
        potTask.configure(this);
        Task poTask = project.getTasks().add("updatePo");
        poTask.setDescription("Update the PO files for all translations from the current state of the POT files");
        poTask.dependsOn(new Object[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getTasks().withType(SynchronizePoTask.class).getAll();
            }
        }});
        Task updateTranslations = project.getTasks().add("updateTranslations");
        updateTranslations.setDescription("Update POT and all PO files");
        updateTranslations.dependsOn(new Object[]{potTask});
        updateTranslations.dependsOn(new Object[]{poTask});
        GenerateXslFoTask xslFoTask = (GenerateXslFoTask)project.getTasks().add("generateXslFo", GenerateXslFoTask.class);
        xslFoTask.setDescription("Generate a XSL-FO file for FOP debugging (provided PDF format specified)");
        xslFoTask.configure(this, this.masterSourceFileResolver);
        this.jDocBookComponentRegistry = new JDocBookComponentRegistry((Environment)new EnvironmentImpl(), (Configuration)new ConfigurationImpl());
    }

    void applyConfiguration(boolean secondaryCall) {
        if (secondaryCall) {
            throw new IllegalStateException("Configuring jDocBook in two sections not supported");
        }
        this.createGroups();
        this.applyLanguage(this.configuration.getMasterLanguage(), true);
        for (String translation : this.configuration.getTranslations()) {
            this.applyLanguage(translation, false);
        }
    }

    private void createGroups() {
        Task profileStage = this.project.getTasks().getByName(PROFILE_TASK_GROUP);
        for (final FormatOptions format : this.configuration.getFormats()) {
            Task formatGroup = this.project.getTasks().add(String.format("formatDocBook_%s", format.getName()));
            formatGroup.setDescription(String.format("Perform all DocBook formatting for the %s format", format.getName()));
            formatGroup.dependsOn(new Object[]{profileStage});
            formatGroup.dependsOn(new Object[]{new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return JDocBookPlugin.this.project.getTasks().withType(RenderTask.class).matching((Spec)new Spec<RenderTask>(){

                        public boolean isSatisfiedBy(RenderTask renderTask) {
                            return format.getName().equals(renderTask.getFormat().getName());
                        }
                    });
                }
            }});
        }
    }

    private void applyLanguage(String language, boolean master) {
        StyleStagingTask stagingTask = (StyleStagingTask)this.project.getTasks().getByName(STAGE_TASK_GROUP);
        TranslateTask translateTask = null;
        if (!master) {
            translateTask = (TranslateTask)this.project.getTasks().add(String.format("translateDocBook_%s", language), TranslateTask.class);
            translateTask.setDescription(String.format("Perform DocBook translation for language %s", language));
            translateTask.configure(this, language);
            SynchronizePoTask poTask = (SynchronizePoTask)this.project.getTasks().add(String.format("updatePo_%s", language), SynchronizePoTask.class);
            translateTask.setDescription(String.format("Update PO files from current POT for language %s", language));
            poTask.configure(this, language);
        }
        DefaultTask formatDependency = translateTask;
        if (this.configuration.getProfiling().isEnabled()) {
            ProfileTask profileTask = (ProfileTask)this.project.getTasks().add(String.format("profileDocBook_%s", language), ProfileTask.class);
            profileTask.setDescription(String.format("Perform DocBook profiling for language %s", language));
            profileTask.configure(this, language);
            if (!master) {
                profileTask.dependsOn(new Object[]{translateTask});
            }
            profileTask.dependsOn(new Object[]{stagingTask});
            formatDependency = profileTask;
        }
        Task formatLanguageGroup = this.project.getTasks().add(String.format("formatDocBook_%s", language));
        formatLanguageGroup.setDescription(String.format("Perform all DocBook formatting for language %s", language));
        for (FormatOptions format : this.configuration.getFormats()) {
            RenderTask renderTask = (RenderTask)this.project.getTasks().add(String.format("renderDocBook_%s_%s", language, format.getName()), RenderTask.class);
            renderTask.setDescription(String.format("Perform DocBook %s formatting for language %s", format.getName(), language));
            renderTask.configure(this, language, format);
            if (formatDependency != null) {
                renderTask.dependsOn(new Object[]{formatDependency});
            }
            renderTask.dependsOn(new Object[]{stagingTask});
            formatLanguageGroup.dependsOn(new Object[]{renderTask});
        }
    }

    private ClassLoader buildResourceDelegateClassLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.directoryLayout.getStagingDirectory().exists()) {
            try {
                urls.add(this.directoryLayout.getStagingDirectory().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new JDocBookProcessException("Unable to resolve staging directory to URL", (Throwable)e);
            }
        }
        for (File file : this.project.getConfigurations().getByName(DOCBOOK_CONFIG_NAME).getFiles()) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warn("Unable to retrieve file url [" + file.getAbsolutePath() + "]; ignoring");
            }
        }
        for (File file : this.project.getBuildscript().getConfigurations().getByName("classpath").getFiles()) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warn("Unable to retrieve file url [" + file.getAbsolutePath() + "]; ignoring");
            }
        }
        for (File file : this.project.getConfigurations().getByName(STYLES_CONFIG_NAME).getFiles()) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warn("Unable to retrieve file url [" + file.getAbsolutePath() + "]; ignoring");
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }

    public Locale fromLanguageString(String languageStr) {
        return TranslationUtils.parse((String)languageStr, (char)this.configuration.getLocaleSeparator());
    }

    void prepareForRendering() {
        if (this.scriptClassLoaderExtended) {
            return;
        }
        this.scriptClassLoaderExtended = true;
        log.lifecycle("Extending script classloader with the {} dependencies", new Object[]{STYLES_CONFIG_NAME});
        ClassLoader classloader = this.getProject().getBuildscript().getClassLoader();
        if (classloader instanceof ObservableUrlClassLoader) {
            ObservableUrlClassLoader scriptClassloader = (ObservableUrlClassLoader)classloader;
            for (File file : this.getProject().getConfigurations().getByName(STYLES_CONFIG_NAME).getFiles()) {
                try {
                    scriptClassloader.addURL(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    log.warn("Unable to retrieve file url [" + file.getAbsolutePath() + "]; ignoring");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationImpl
    implements Configuration {
        private LinkedHashSet<ValueInjection> valueInjections;

        private ConfigurationImpl() {
        }

        private JDocBookConfiguration gradleConfiguration() {
            return JDocBookPlugin.this.getConfiguration();
        }

        public Properties getTransformerParameters() {
            return this.gradleConfiguration().getTransformerParameters();
        }

        public boolean isUseRelativeImageUris() {
            return this.gradleConfiguration().isUseRelativeImageUris();
        }

        public char getLocaleSeparator() {
            return this.gradleConfiguration().getLocaleSeparator();
        }

        public boolean isAutoDetectFontsEnabled() {
            return this.gradleConfiguration().isAutoDetectFonts();
        }

        public boolean isUseFopFontCacheEnabled() {
            return this.gradleConfiguration().isUseFopFontCache();
        }

        public LinkedHashSet<ValueInjection> getValueInjections() {
            if (this.valueInjections == null) {
                this.valueInjections = new LinkedHashSet();
                this.valueInjections.addAll(this.gradleConfiguration().getValueInjections());
                if (this.gradleConfiguration().isApplyStandardInjectionValues()) {
                    this.valueInjections.add(new ValueInjection("version", JDocBookPlugin.this.project.getVersion().toString()));
                    SimpleDateFormat dateFormat = new SimpleDateFormat(this.gradleConfiguration().getInjectionDateFormat());
                    this.valueInjections.add(new ValueInjection("today", dateFormat.format(new Date())));
                }
            }
            return this.valueInjections;
        }

        public LinkedHashSet<String> getCatalogs() {
            return this.gradleConfiguration().getCatalogs();
        }

        public Profiling getProfiling() {
            return this.gradleConfiguration().getProfiling();
        }

        public String getDocBookVersion() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterLanguageDescriptorImpl
    implements MasterLanguageDescriptor {
        private MasterLanguageDescriptorImpl() {
        }

        public Locale getLanguage() {
            return TranslationUtils.parse((String)JDocBookPlugin.this.getConfiguration().getMasterLanguage(), (char)JDocBookPlugin.this.getConfiguration().getLocaleSeparator());
        }

        public File getPotDirectory() {
            return JDocBookPlugin.this.directoryLayout.getPotSourceDirectory();
        }

        public File getBaseSourceDirectory() {
            return JDocBookPlugin.this.directoryLayout.getMasterSourceDirectory();
        }

        public File getRootDocumentFile() {
            return JDocBookPlugin.this.masterSourceFileResolver.getMainMasterFile();
        }

        public Set<File> getDocumentFiles() {
            return JDocBookPlugin.this.masterSourceFileResolver.getFiles();
        }
    }

    private class ResourceDelegateImpl
    extends ResourceDelegateSupport {
        private ClassLoader loader;

        private ResourceDelegateImpl() {
        }

        protected ClassLoader getResourceClassLoader() {
            if (this.loader == null) {
                this.loader = JDocBookPlugin.this.buildResourceDelegateClassLoader();
            }
            return this.loader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnvironmentImpl
    implements Environment {
        private final ResourceDelegateImpl resourceDelegate;
        private final MasterLanguageDescriptorImpl masterDescriptor;

        private EnvironmentImpl() {
            this.resourceDelegate = new ResourceDelegateImpl();
            this.masterDescriptor = new MasterLanguageDescriptorImpl();
        }

        public ResourceDelegate getResourceDelegate() {
            return this.resourceDelegate;
        }

        public MasterLanguageDescriptor getMasterLanguageDescriptor() {
            return this.masterDescriptor;
        }

        public File getWorkDirectory() {
            return JDocBookPlugin.this.directoryLayout.getRootJDocBookWorkDirectory();
        }

        public File getStagingDirectory() {
            return JDocBookPlugin.this.directoryLayout.getStagingDirectory();
        }

        public List<File> getFontDirectories() {
            return Collections.singletonList(JDocBookPlugin.this.directoryLayout.getFontsDirectory());
        }

        public Environment.DocBookXsltResolutionStrategy getDocBookXsltResolutionStrategy() {
            return Environment.DocBookXsltResolutionStrategy.INCLUSIVE;
        }
    }
}

