/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.gradle.plugins.jdocbook.JDocBookPlugin;
import org.jboss.jdocbook.util.XIncludeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterSourceFileResolver {
    private static final Logger log = LoggerFactory.getLogger(MasterSourceFileResolver.class);
    private final JDocBookPlugin plugin;
    private File mainMasterFile;
    private Set<File> masterFiles;

    MasterSourceFileResolver(JDocBookPlugin plugin) {
        this.plugin = plugin;
    }

    public File getMainMasterFile() {
        if (this.mainMasterFile == null) {
            this.mainMasterFile = new File(this.plugin.getDirectoryLayout().getMasterSourceDirectory(), this.plugin.getConfiguration().getMasterSourceDocumentName());
            if (!this.mainMasterFile.exists()) {
                log.error("Master document [{}] did not exist!", (Object)this.mainMasterFile.getAbsolutePath());
            }
        }
        return this.mainMasterFile;
    }

    public Set<File> getFiles() {
        if (this.masterFiles == null) {
            File mainMasterFile = this.getMainMasterFile();
            TreeSet<File> files = new TreeSet<File>();
            files.add(mainMasterFile);
            XIncludeHelper.findAllInclusionFiles((File)mainMasterFile, files);
            this.masterFiles = Collections.unmodifiableSet(files);
        }
        return this.masterFiles;
    }
}

