/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import java.io.File;
import java.util.Locale;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jboss.gradle.plugins.jdocbook.JDocBookPlugin;
import org.jboss.jdocbook.Profiling;
import org.jboss.jdocbook.profile.ProfilingSource;

public class ProfileTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(ProfileTask.class);
    private JDocBookPlugin plugin;
    private String language;
    private ProfilingSourceImpl profilingSource;

    public void configure(JDocBookPlugin plugin, String language) {
        this.plugin = plugin;
        this.language = language;
        this.profilingSource = new ProfilingSourceImpl();
    }

    @Input
    public String getLanguage() {
        return this.language;
    }

    public Profiling getProfiling() {
        return this.plugin.getConfiguration().getProfiling();
    }

    @Input
    public boolean isProfilingEnabled() {
        return this.getProfiling().isEnabled();
    }

    @Input
    @Optional
    public String isProfilingAttributeName() {
        return this.getProfiling().getAttributeName();
    }

    @Input
    @Optional
    public String isProfilingAttributeValue() {
        return this.getProfiling().getAttributeValue();
    }

    @InputDirectory
    public File getProfileInputDirectory() {
        return this.getLanguage().equals(this.plugin.getConfiguration().getMasterLanguage()) ? this.plugin.getDirectoryLayout().getMasterSourceDirectory() : this.plugin.getDirectoryLayout().getTranslationDirectory(this.getLanguage());
    }

    @OutputDirectory
    public File getProfileOutputDirectory() {
        return this.plugin.getDirectoryLayout().getProfilingDirectory(this.getLanguage());
    }

    @TaskAction
    public void profile() {
        log.lifecycle("profiling {} into {}", new Object[]{this.getLanguage(), this.getProfileOutputDirectory()});
        this.plugin.getComponentRegistry().getProfiler().profile((ProfilingSource)this.profilingSource);
    }

    private class ProfilingSourceImpl
    implements ProfilingSource {
        private ProfilingSourceImpl() {
        }

        public Locale getLanguage() {
            return ProfileTask.this.plugin.fromLanguageString(ProfileTask.this.language);
        }

        public File resolveDocumentFile() {
            return new File(ProfileTask.this.getProfileInputDirectory(), ProfileTask.this.plugin.getConfiguration().getMasterSourceDocumentName());
        }

        public File resolveProfiledDocumentFile() {
            return new File(ProfileTask.this.getProfileOutputDirectory(), ProfileTask.this.plugin.getConfiguration().getMasterSourceDocumentName());
        }
    }
}

