/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import java.io.File;
import java.util.Locale;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jboss.gradle.plugins.jdocbook.JDocBookPlugin;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.render.RenderingSource;

public class RenderTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(RenderTask.class);
    private JDocBookPlugin plugin;
    private String language;
    private FormatOptions format;
    private RenderingSourceImpl renderingSource;

    public void configure(JDocBookPlugin plugin, String language, FormatOptions format) {
        this.plugin = plugin;
        this.language = language;
        this.format = format;
        this.renderingSource = new RenderingSourceImpl();
    }

    @Input
    public String getLanguage() {
        return this.language;
    }

    public FormatOptions getFormat() {
        return this.format;
    }

    @Input
    public String getFormatName() {
        return this.getFormat().getName();
    }

    @Input
    @Optional
    public String getFormatFinalName() {
        return this.getFormat().getTargetFinalName();
    }

    @Input
    @Optional
    public String getFormatStylesheetResource() {
        return this.getFormat().getStylesheetResource();
    }

    @InputDirectory
    public File getDocumentDirectory() {
        if (this.plugin.getConfiguration().getProfiling().isEnabled()) {
            return this.plugin.getDirectoryLayout().getProfilingDirectory(this.getLanguage());
        }
        if (this.getLanguage().equals(this.plugin.getConfiguration().getMasterLanguage())) {
            return this.plugin.getDirectoryLayout().getMasterSourceDirectory();
        }
        return this.plugin.getDirectoryLayout().getTranslationDirectory(this.getLanguage());
    }

    @OutputDirectory
    public File getPublishDirectory() {
        return this.plugin.getDirectoryLayout().getPublishDirectory(this.getLanguage(), this.getFormat().getName());
    }

    @TaskAction
    public void render() {
        this.plugin.prepareForRendering();
        log.lifecycle("rendering {} / {}", new Object[]{this.getLanguage(), this.getFormat().getName()});
        this.plugin.getComponentRegistry().getRenderer().render((RenderingSource)this.renderingSource, this.format);
    }

    private class RenderingSourceImpl
    implements RenderingSource {
        private RenderingSourceImpl() {
        }

        public Locale getLanguage() {
            return RenderTask.this.plugin.fromLanguageString(RenderTask.this.language);
        }

        public File resolveSourceDocument() {
            return new File(RenderTask.this.getDocumentDirectory(), RenderTask.this.plugin.getConfiguration().getMasterSourceDocumentName());
        }

        public File resolvePublishingBaseDirectory() {
            return RenderTask.this.plugin.getDirectoryLayout().getPublishBaseDirectory(RenderTask.this.getLanguage());
        }

        public File getXslFoDirectory() {
            return RenderTask.this.plugin.getDirectoryLayout().getXslFoDirectory(RenderTask.this.getLanguage());
        }
    }
}

