/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.ext.formatters;

import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.ext.formatters.StringBuilderWriter;

public abstract class StructuredFormatter
extends ExtFormatter {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            String dateFormat = StructuredFormatter.this.datePattern;
            return new SimpleDateFormat(dateFormat == null ? StructuredFormatter.DEFAULT_DATE_FORMAT : dateFormat);
        }
    };
    private final Map<Key, String> keyOverrides;
    private volatile boolean printDetails = false;
    private volatile String datePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private volatile boolean addEolChar = true;

    protected StructuredFormatter() {
        this(Collections.emptyMap());
    }

    protected StructuredFormatter(Map<Key, String> keyOverrides) {
        this.keyOverrides = keyOverrides;
    }

    protected abstract Generator createGenerator(Writer var1) throws Exception;

    protected void before(Generator generator, ExtLogRecord record) throws Exception {
    }

    protected void after(Generator generator, ExtLogRecord record) throws Exception {
    }

    protected final String getKey(Key defaultKey) {
        if (this.keyOverrides.containsKey((Object)defaultKey)) {
            return this.keyOverrides.get((Object)defaultKey);
        }
        return defaultKey.getKey();
    }

    public String format(ExtLogRecord record) {
        boolean details = this.printDetails;
        try {
            SimpleDateFormat sdf = this.dateFormatThreadLocal.get();
            String pattern = this.datePattern;
            if (!sdf.toPattern().equals(pattern)) {
                sdf.applyPattern(pattern);
            }
            StringBuilderWriter writer = new StringBuilderWriter();
            Generator generator = this.createGenerator(writer).begin();
            this.before(generator, record);
            generator.add(this.getKey(Key.TIMESTAMP), this.dateFormatThreadLocal.get().format(new Date(record.getMillis()))).add(this.getKey(Key.SEQUENCE), record.getSequenceNumber()).add(this.getKey(Key.LOGGER_CLASS_NAME), record.getLoggerClassName()).add(this.getKey(Key.LOGGER_NAME), record.getLoggerName()).add(this.getKey(Key.LEVEL), record.getLevel().getName()).add(this.getKey(Key.THREAD_NAME), record.getThreadName()).add(this.getKey(Key.MESSAGE), record.getFormattedMessage()).add(this.getKey(Key.THREAD_ID), record.getThreadID()).add(this.getKey(Key.MDC), record.getMdcCopy()).add(this.getKey(Key.NDC), record.getNdc()).addStackTrace(record.getThrown());
            if (details) {
                generator.add(this.getKey(Key.SOURCE_CLASS_NAME), record.getSourceClassName()).add(this.getKey(Key.SOURCE_FILE_NAME), record.getSourceFileName()).add(this.getKey(Key.SOURCE_METHOD_NAME), record.getSourceMethodName()).add(this.getKey(Key.SOURCE_LINE_NUMBER), record.getSourceLineNumber());
            }
            this.after(generator, record);
            generator.end();
            if (this.addEolChar) {
                writer.append('\n');
            }
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAppendEndOfLine() {
        return this.addEolChar;
    }

    public void setAppendEndOfLine(boolean addEolChar) {
        this.addEolChar = addEolChar;
    }

    public String getDateFormat() {
        return this.datePattern;
    }

    public void setDateFormat(String pattern) {
        this.datePattern = pattern == null ? DEFAULT_DATE_FORMAT : pattern;
    }

    public boolean isPrintDetails() {
        return this.printDetails;
    }

    public void setPrintDetails(boolean printDetails) {
        this.printDetails = printDetails;
    }

    protected static abstract class Generator {
        protected Generator() {
        }

        public Generator begin() throws Exception {
            return this;
        }

        public Generator add(String key, int value) throws Exception {
            this.add(key, Integer.toString(value));
            return this;
        }

        public Generator add(String key, long value) throws Exception {
            this.add(key, Long.toString(value));
            return this;
        }

        public abstract Generator add(String var1, Map<String, ?> var2) throws Exception;

        public abstract Generator add(String var1, String var2) throws Exception;

        public abstract Generator addStackTrace(Throwable var1) throws Exception;

        public abstract Generator end() throws Exception;
    }

    public static enum Key {
        EXCEPTION("exception"),
        EXCEPTION_FRAME("frame"),
        EXCEPTION_FRAME_CLASS("class"),
        EXCEPTION_FRAME_LINE("line"),
        EXCEPTION_FRAME_METHOD("method"),
        EXCEPTION_FRAMES("frames"),
        EXCEPTION_MESSAGE("message"),
        LEVEL("level"),
        LOGGER_CLASS_NAME("loggerClassName"),
        LOGGER_NAME("loggerName"),
        MDC("mdc"),
        MESSAGE("message"),
        NDC("ndc"),
        RECORD("record"),
        SEQUENCE("sequence"),
        SOURCE_CLASS_NAME("sourceClassName"),
        SOURCE_FILE_NAME("sourceFileName"),
        SOURCE_LINE_NUMBER("sourceLineNumber"),
        SOURCE_METHOD_NAME("sourceMethodName"),
        THREAD_ID("threadId"),
        THREAD_NAME("threadName"),
        TIMESTAMP("timestamp");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

