/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.ext.handlers;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.SslTcpOutputStream;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.jboss.logmanager.handlers.UdpOutputStream;
import org.jboss.logmanager.handlers.UninterruptibleOutputStream;

public class SocketHandler
extends ExtHandler {
    public static final int DEFAULT_PORT = 4560;
    private InetAddress address;
    private int port;
    private Protocol protocol;
    private Writer writer;
    private boolean initialize;

    public SocketHandler() throws UnknownHostException {
        this(InetAddress.getLocalHost(), 4560);
    }

    public SocketHandler(String hostname, int port) throws UnknownHostException {
        this(InetAddress.getByName(hostname), port);
    }

    public SocketHandler(InetAddress address, int port) {
        this(Protocol.TCP, address, port);
    }

    public SocketHandler(Protocol protocol, String hostname, int port) throws UnknownHostException {
        this(protocol, InetAddress.getByName(hostname), port);
    }

    public SocketHandler(Protocol protocol, InetAddress address, int port) {
        this.address = address;
        this.port = port;
        this.protocol = protocol;
        this.initialize = true;
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPublish(ExtLogRecord record) {
        String formatted;
        Formatter formatter = this.getFormatter();
        try {
            formatted = formatter.format((LogRecord)record);
        }
        catch (Exception e) {
            this.reportError("Could not format message", e, 5);
            return;
        }
        if (formatted.isEmpty()) {
            return;
        }
        try {
            SocketHandler e = this;
            synchronized (e) {
                if (this.initialize) {
                    this.initialize();
                }
                if (this.writer == null) {
                    return;
                }
                this.writer.write(formatted);
                super.doPublish(record);
            }
        }
        catch (Exception e) {
            this.reportError("Error writing log message", e, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        SocketHandler socketHandler = this;
        synchronized (socketHandler) {
            this.safeFlush(this.writer);
        }
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SecurityException {
        SocketHandler.checkAccess((ExtHandler)this);
        SocketHandler socketHandler = this;
        synchronized (socketHandler) {
            this.safeClose(this.writer);
            this.writer = null;
        }
        super.close();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress address) {
        SocketHandler.checkAccess((ExtHandler)this);
        SocketHandler socketHandler = this;
        synchronized (socketHandler) {
            this.address = address;
            this.initialize = true;
        }
    }

    public void setHostname(String hostname) throws UnknownHostException {
        SocketHandler.checkAccess((ExtHandler)this);
        this.setAddress(InetAddress.getByName(hostname));
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocol(Protocol protocol) {
        SocketHandler.checkAccess((ExtHandler)this);
        SocketHandler socketHandler = this;
        synchronized (socketHandler) {
            this.protocol = protocol;
            this.initialize = true;
        }
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        SocketHandler.checkAccess((ExtHandler)this);
        SocketHandler socketHandler = this;
        synchronized (socketHandler) {
            this.port = port;
            this.initialize = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Writer current = this.writer;
        boolean okay = false;
        try {
            OutputStream out;
            if (current != null) {
                this.writeTail(current);
                this.safeFlush(current);
            }
            if ((out = this.createOutputStream()) == null) {
                return;
            }
            String encoding = this.getEncoding();
            UninterruptibleOutputStream outputStream = new UninterruptibleOutputStream(out);
            this.writer = encoding == null ? new OutputStreamWriter((OutputStream)outputStream) : new OutputStreamWriter((OutputStream)outputStream, encoding);
            this.writeHead(this.writer);
            okay = true;
        }
        catch (UnsupportedEncodingException e) {
            this.reportError("Error opening", e, 4);
        }
        finally {
            this.safeClose(current);
            if (!okay) {
                this.safeClose(this.writer);
            }
        }
    }

    private OutputStream createOutputStream() {
        if (this.address != null || this.port >= 0) {
            try {
                if (this.protocol == Protocol.SSL_TCP) {
                    return new SslTcpOutputStream(this.address, this.port);
                }
                if (this.protocol == Protocol.UDP) {
                    return new UdpOutputStream(this.address, this.port);
                }
                return new TcpOutputStream(this.address, this.port);
            }
            catch (IOException e) {
                this.reportError("Failed to create socket output stream", e, 4);
            }
        }
        return null;
    }

    private void writeHead(Writer writer) {
        try {
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                writer.write(formatter.getHead((Handler)((Object)this)));
            }
        }
        catch (Exception e) {
            this.reportError("Error writing section header", e, 1);
        }
    }

    private void writeTail(Writer writer) {
        try {
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                writer.write(formatter.getTail((Handler)((Object)this)));
            }
        }
        catch (Exception ex) {
            this.reportError("Error writing section tail", ex, 1);
        }
    }

    private void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            this.reportError("Error closing resource", e, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeFlush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (Exception e) {
            this.reportError("Error on flush", e, 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        SSL_TCP;

    }
}

