/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.impl.manager;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.interceptor.InvocationContext;
import javax.naming.Context;
import org.jboss.interceptor.proxy.DefaultInvocationContextFactory;
import org.jboss.interceptor.proxy.InterceptorInvocation;
import org.jboss.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.interceptor.spi.context.InterceptionChain;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.managed.bean.impl.ManagedBeanInstanceImpl;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.metadata.MethodMetadata;
import org.jboss.managed.bean.spi.ManagedBeanInstance;
import org.jboss.managed.bean.spi.ManagedBeanManager;
import org.jboss.reloaded.naming.spi.JavaEEModule;

public class ManagedBeanManagerImpl<T>
implements ManagedBeanManager<T> {
    protected ManagedBeanMetaData mbMetaData;
    protected Class<T> managedBeanClass;
    private JavaEEModule javaeeModule;
    private Method postConstructMethod;

    public ManagedBeanManagerImpl(Class<T> beanClass, ManagedBeanMetaData beanMetaData) {
        this.managedBeanClass = beanClass;
        this.mbMetaData = beanMetaData;
    }

    public ManagedBeanManagerImpl(Class<T> beanClass, ManagedBeanMetaData beanMetaData, JavaEEModule javaeeModule) {
        this.managedBeanClass = beanClass;
        this.mbMetaData = beanMetaData;
        this.javaeeModule = javaeeModule;
    }

    public ManagedBeanMetaData getMetadata() {
        return this.mbMetaData;
    }

    public Object invoke(ManagedBeanInstance<T> managedBeanInstance, Method method, Object[] args) throws Throwable {
        List aroundInvokeInterceptors = this.mbMetaData.getAroundInvokeInterceptors();
        ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(aroundInvokeInterceptors.size());
        for (InterceptorMetadata aroundInvokeInterceptor : aroundInvokeInterceptors) {
            String interceptorClassName = aroundInvokeInterceptor.getInterceptorClass().getClassName();
            Object interceptorInstance = managedBeanInstance.getInterceptor(interceptorClassName);
            InterceptorInvocation interceptorInvocation = new InterceptorInvocation(interceptorInstance, aroundInvokeInterceptor, InterceptionType.AROUND_INVOKE);
            interceptorInvocations.add(interceptorInvocation);
        }
        SimpleInterceptionChain interceptorChain = new SimpleInterceptionChain(interceptorInvocations, InterceptionType.AROUND_INVOKE, managedBeanInstance.getInstance(), method);
        DefaultInvocationContextFactory invocationCtxFactory = new DefaultInvocationContextFactory();
        InvocationContext invocationCtx = invocationCtxFactory.newInvocationContext((InterceptionChain)interceptorChain, managedBeanInstance.getInstance(), method, args);
        return invocationCtx.proceed();
    }

    public ManagedBeanInstance<T> createManagedBeanInstance() throws Exception {
        T instance = this.createInstance(this.managedBeanClass);
        Collection<Object> interceptorInstances = this.createInterceptors();
        ManagedBeanInstanceImpl<T> mbInstance = new ManagedBeanInstanceImpl<T>(instance, interceptorInstances);
        this.handlePostConstruct(mbInstance);
        return mbInstance;
    }

    public void setJavaEEModule(JavaEEModule javaeeModule) throws IllegalStateException {
        if (this.javaeeModule != null) {
            throw new IllegalStateException("JavaEEModule for managed bean: " + this.managedBeanClass + " is already set");
        }
        this.javaeeModule = javaeeModule;
    }

    public Context getENC() {
        if (this.javaeeModule == null) {
            throw new IllegalStateException("JavaEEModule for managed bean: " + this.managedBeanClass + " has not yet been setup");
        }
        return this.javaeeModule.getContext();
    }

    private Method getPostConstructMethod() {
        if (this.postConstructMethod == null && this.mbMetaData.getPostConstructMethod() != null) {
            this.initPostConstructMethod();
        }
        return this.postConstructMethod;
    }

    private void initPostConstructMethod() {
        MethodMetadata postConstructMetadata = this.mbMetaData.getPostConstructMethod();
        String methodName = postConstructMetadata.getMethodName();
        String[] params = postConstructMetadata.getMethodParams();
        if (params == null) {
            params = new String[]{};
        }
        ClassLoader cl = this.managedBeanClass.getClassLoader();
        Class[] paramTypes = new Class[params.length];
        int i = 0;
        for (String param : params) {
            try {
                paramTypes[i++] = Class.forName(param, false, cl);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load post-construct method param type: " + param, cnfe);
            }
        }
        for (Class<T> klass = this.managedBeanClass; klass != null; klass = klass.getSuperclass()) {
            try {
                this.postConstructMethod = klass.getDeclaredMethod(methodName, paramTypes);
                return;
            }
            catch (SecurityException se) {
                throw new RuntimeException("Could not find post-construct method named: " + methodName + " on managed bean: " + this.managedBeanClass);
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
        }
    }

    private void handlePostConstruct(ManagedBeanInstance<T> managedBeanInstance) throws Exception {
        List postConstructInterceptors = this.mbMetaData.getPostConstructInterceptors();
        ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(postConstructInterceptors.size());
        for (InterceptorMetadata postConstructInterceptor : postConstructInterceptors) {
            String interceptorClassName = postConstructInterceptor.getInterceptorClass().getClassName();
            Object interceptorInstance = managedBeanInstance.getInterceptor(interceptorClassName);
            InterceptorInvocation interceptorInvocation = new InterceptorInvocation(interceptorInstance, postConstructInterceptor, InterceptionType.POST_CONSTRUCT);
            interceptorInvocations.add(interceptorInvocation);
        }
        SimpleInterceptionChain interceptorChain = new SimpleInterceptionChain(interceptorInvocations, InterceptionType.POST_CONSTRUCT, managedBeanInstance.getInstance(), this.getPostConstructMethod());
        DefaultInvocationContextFactory invocationCtxFactory = new DefaultInvocationContextFactory();
        InvocationContext invocationCtx = invocationCtxFactory.newInvocationContext((InterceptionChain)interceptorChain, managedBeanInstance.getInstance(), this.postConstructMethod, null);
        invocationCtx.proceed();
    }

    private Collection<Object> createInterceptors() {
        ArrayList<Object> interceptorInstances = new ArrayList<Object>(this.mbMetaData.getInterceptors().size());
        for (InterceptorMetadata interceptor : this.mbMetaData.getInterceptors()) {
            String interceptorClassName = interceptor.getInterceptorClass().getClassName();
            try {
                Class<?> interceptorClass = Class.forName(interceptorClassName, false, this.managedBeanClass.getClassLoader());
                Object interceptorInstance = this.createInstance(interceptorClass);
                interceptorInstances.add(interceptorInstance);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load interceptor class: " + interceptorClassName, cnfe);
            }
        }
        return interceptorInstances;
    }

    private <I> I createInstance(Class<I> klass) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }
}

