/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.bean.mc;

import javax.naming.Context;
import javax.naming.NamingException;

import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.reloaded.naming.spi.JavaEEModule;

/**
 * JNDIBinder
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class JNDIBinder
{

   private static Logger logger = Logger.getLogger(JNDIBinder.class);

   private JavaEEModule javaeeModule;

   private String jndiName;

   private Object jndiObject;

   private boolean bound;

   private boolean javaAppBinder;

   public JNDIBinder(String jndiName, Object obj)
   {
      this(jndiName, obj, false);
   }

   public JNDIBinder(String jndiName, Object obj, boolean javaAppBinder)
   {
      this.jndiName = jndiName;
      this.jndiObject = obj;
      this.javaAppBinder = javaAppBinder;
   }

   @Start
   public void bind() throws NamingException
   {
      Context ctx = this.getContext();
      if (ctx == null)
      {
         throw new IllegalStateException("JNDI context is null, cannot bind jndi name " + this.jndiName);
      }

      logger.info("Binding Managed Bean in jndi namespace " + this.getNamespace() + " at jndiname " + this.jndiName);

      Util.bind(ctx, this.jndiName, this.jndiObject);
      this.bound = true;
   }

   @Stop
   public void unbind() throws NamingException
   {
      if (!this.bound)
      {
         return;
      }
      Context ctx = this.getContext();
      if (ctx == null)
      {
         throw new IllegalStateException("JNDI context is null, cannot unbind from jndi name " + this.jndiName);
      }
      logger.info("Unbinding Managed Bean from jndi namespace " + this.getNamespace() + " at jndiname "
            + this.jndiName);

      // Don't use Util.unbind() because it even destroy the parent context (after unbinding) if the
      // parent context is empty.
      //Util.unbind(ctx, this.jndiName);
      ctx.unbind(this.jndiName);
   }

   private String getNamespace()
   {
      if (this.javaAppBinder)
      {
         return "java:app/";
      }
      return "java:module/";
   }

   public void setJavaEEModule(JavaEEModule javaeeModule)
   {
      this.javaeeModule = javaeeModule;
   }

   private Context getContext()
   {
      if (this.javaeeModule == null)
      {
         throw new IllegalStateException("JavaEEModule is not set. Cannot return JNDI context");
      }
      if (this.javaAppBinder)
      {
         return this.javaeeModule.getApplication().getContext();
      }
      return this.javaeeModule.getContext();
   }
}
