/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.metadata.jbmeta.annotation.processor;

import java.lang.reflect.AnnotatedElement;
import javax.annotation.ManagedBean;
import org.jboss.managed.bean.metadata.ManagedBeanDeploymentMetaData;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.metadata.jbmeta.JBMetaManagedBeanMetaData;
import org.jboss.managed.bean.metadata.jbmeta.annotation.processor.InterceptorsProcessor;
import org.jboss.managed.bean.metadata.jbmeta.annotation.processor.PostConstructProcessor;
import org.jboss.metadata.annotation.creator.AbstractComponentProcessor;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;

public class ManagedBeanProcessor
extends AbstractComponentProcessor<ManagedBeanMetaData>
implements Processor<ManagedBeanDeploymentMetaData, Class<?>> {
    public ManagedBeanProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new InterceptorsProcessor(finder));
        this.addMethodProcessor(new InterceptorsProcessor(finder));
        this.addMethodProcessor(new PostConstructProcessor(finder));
    }

    public void process(ManagedBeanDeploymentMetaData managedBeanDeploymentMetaData, Class<?> managedBeanClass) {
        ManagedBean managedBeanAnnotation = (ManagedBean)this.finder.getAnnotation(managedBeanClass, ManagedBean.class);
        if (managedBeanAnnotation == null) {
            return;
        }
        JBMetaManagedBeanMetaData managedBeanMetaData = new JBMetaManagedBeanMetaData();
        managedBeanMetaData.setManagedBeanClass(managedBeanClass.getName());
        String explicitName = managedBeanAnnotation.value();
        if (explicitName != null && !explicitName.isEmpty()) {
            managedBeanMetaData.setName(explicitName);
        } else {
            managedBeanMetaData.setName(managedBeanClass.getSimpleName());
        }
        managedBeanDeploymentMetaData.addManagedBeans(new ManagedBeanMetaData[]{managedBeanMetaData});
        super.processClass((Object)managedBeanMetaData, managedBeanClass);
        EnvironmentRefsGroupMetaData env = managedBeanMetaData.getEnvironment();
        if (env == null) {
            env = new EnvironmentRefsGroupMetaData();
            managedBeanMetaData.setEnvironment(env);
        }
        super.process(env, managedBeanClass);
    }
}

