/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.metadata.jbmeta;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.metadata.MethodMetadata;
import org.jboss.managed.bean.metadata.jbmeta.InterceptorBindingMetaData;
import org.jboss.managed.bean.metadata.jbmeta.MethodMetadataImpl;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;

public class ManagedBeanMetaDataImpl
implements ManagedBeanMetaData {
    private String managedBeanClass;
    private String managedBeanName;
    private List<InterceptorBindingMetaData> interceptorBindings = new ArrayList<InterceptorBindingMetaData>();
    private InterceptorMetadata<?> postConstruct;
    private MethodMetadata preDestroyMethod;
    private EnvironmentRefsGroupMetaData environment;
    private List<InterceptorMetadata<?>> aroundInvokes = new ArrayList();
    private List<InterceptorMetadata<?>> classLevelInterceptors = new ArrayList();
    private Map<MethodMetadata, InterceptorBindingMetaData> methodLevelInterceptorBindings = new HashMap<MethodMetadata, InterceptorBindingMetaData>();
    private List<InterceptorMetadata<?>> allInterceptors = new ArrayList();

    public String getManagedBeanClass() {
        return this.managedBeanClass;
    }

    public String getName() {
        return this.managedBeanName;
    }

    public Collection<InterceptorMetadata<?>> getAllInterceptors() {
        return this.allInterceptors;
    }

    public List<InterceptorMetadata<?>> getPostConstructs() {
        ArrayList applicablePostConstructs = new ArrayList();
        applicablePostConstructs.addAll(this.classLevelInterceptors);
        if (this.postConstruct != null) {
            applicablePostConstructs.add(this.postConstruct);
        }
        return applicablePostConstructs;
    }

    public void setPostConstructMethod(InterceptorMetadata<?> postConstructInterceptorMetadata) {
        this.postConstruct = postConstructInterceptorMetadata;
    }

    public void setManagedBeanClass(String managedBeanClass) {
        this.managedBeanClass = managedBeanClass;
    }

    public void setName(String name) {
        this.managedBeanName = name;
    }

    public void addInterceptorBinding(InterceptorBindingMetaData interceptorBinding) {
        this.interceptorBindings.add(interceptorBinding);
        this.allInterceptors.addAll(interceptorBinding.getInterceptors());
        this.classifyInterceptorBinding(interceptorBinding);
    }

    public void addAroundInvoke(InterceptorMetadata<?> methodMetadata) {
        this.aroundInvokes.add(methodMetadata);
    }

    public EnvironmentRefsGroupMetaData getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentRefsGroupMetaData environment) {
        this.environment = environment;
    }

    private void classifyInterceptorBinding(InterceptorBindingMetaData interceptorBinding) {
        if (interceptorBinding.isClassLevelBinding()) {
            this.classLevelInterceptors.addAll(interceptorBinding.getInterceptors());
        } else {
            MethodMetadata method = interceptorBinding.getMethod();
            this.methodLevelInterceptorBindings.put(method, interceptorBinding);
        }
    }

    public List<InterceptorMetadata<?>> getAroundInvokes(Method method) {
        if (method == null) {
            return Collections.emptyList();
        }
        ArrayList applicableInterceptors = new ArrayList();
        MethodMetadataImpl methodMetadata = new MethodMetadataImpl(method);
        InterceptorBindingMetaData methodApplicableInterceptorBinding = this.methodLevelInterceptorBindings.get(methodMetadata);
        if (methodApplicableInterceptorBinding == null) {
            applicableInterceptors.addAll(this.classLevelInterceptors);
        } else {
            if (!methodApplicableInterceptorBinding.isExcludeClassInterceptors()) {
                applicableInterceptors.addAll(this.classLevelInterceptors);
            }
            applicableInterceptors.addAll(methodApplicableInterceptorBinding.getInterceptors());
        }
        applicableInterceptors.addAll(this.aroundInvokes);
        return applicableInterceptors;
    }
}

