/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.nbf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.xerces.xs.PSVIProvider;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.nbf.NBFHandlers;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NBFParser {
    private NBFHandlers handler;
    private SAXParser saxParser;
    private Schema schema;
    private static final Logger log = LogManager.getLogger(NBFParser.class);

    public NBFParser(String xsdFilename) throws ConfigurationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            File file = new File(xsdFilename);
            if (!file.exists()) {
                throw new ConfigurationException("Could not find " + xsdFilename);
            }
            this.schema = schemaFactory.newSchema(file);
            factory.setSchema(this.schema);
            this.saxParser = factory.newSAXParser();
            PSVIProvider p = (PSVIProvider)this.saxParser.getXMLReader();
            this.handler = new NBFHandlers(p);
        }
        catch (SAXException e) {
            log.error((Object)("Could not create a SAXParser: " + e.getMessage()), (Throwable)e);
            throw new ConfigurationException("Could not create a SAXParser: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Could not create a SAXParser: " + e.getMessage()), (Throwable)e);
            throw new ConfigurationException("Could not create a SAXParser: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error((Object)("Could not create a SAXParser: " + e.getMessage()), e);
            throw new ConfigurationException("Could not create a SAXParser: " + e.getMessage());
        }
    }

    public void setId(String id) {
        this.handler.setId(id);
    }

    public void setIndex(int index) {
        this.handler.setIndex(index);
    }

    public String getType() {
        return this.handler.getType();
    }

    public String getValue() {
        return this.handler.getValue();
    }

    public boolean parse(byte[] buffer) throws ConfigurationException {
        boolean result = false;
        try {
            this.schema.newValidator().validate(new StreamSource(new ByteArrayInputStream(buffer)));
            this.saxParser.parse((InputStream)new ByteArrayInputStream(buffer), (DefaultHandler)this.handler);
            result = true;
        }
        catch (Throwable e) {
            log.error((Object)("Parser buffer failed with " + e.getMessage()), e);
            throw new ConfigurationException("Parser buffer failed with " + e.getMessage());
        }
        return result;
    }
}

